#include "build.h"
#include "ff.h"
#include "proto.h"
#include "col.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;

  int i_rel, j_rel, j_species;
  int i, j, k, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms, n_mols1;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch, sim_switch, temp_switch, start_switch;

  /* Random generator */
  long i_ran, seed, idum;

  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;

  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers;
  double rho, aspect_xy, aspect_xz, layer_spacing;
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl,
         volume;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0;
  mass_entry *mass = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;
  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, 
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save;
  FILE *f_thermo, *f_trajec, *f_dist, *f_free, *f_output;
  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot;
  double ***comb_par;
  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass, 
      *sqrt_kT_over_m, *one_over_2m, **mol_vels;
  int *atom_rel, *atom_mol, *atom_type, *hot_atom;
  int hot_flag;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;
  double **mol_inert_mt, ***mol_inert_axis;
  /* Monte Carlo parameters. */
  int i_cycle, n_cycles, n_trajec, n_block, n_blocks, n_inst, count,
      n_bins, n_dist, n_r_par, n_r_perp, pos_1, i_r, i_r_perp,
      i_r_par, n_config;

/* Array for Pair Correlation function */
  double dum1, dum2, r_max, r2_max, theta_max, deltatheta, 
        *g_r, *g_1, *g_2, *g_1_hist, *g_2_hist, *g_1_theta, *g_2_theta, 
        **g_r_par_perp, **g_1_par_perp, **g_2_par_perp,
        deltaR, one_over_deltaR, r_par_incr, one_over_r_par_incr, r_perp_incr,
        one_over_r_perp_incr, r, r_1, r_2, r_perp_1, r_perp_2, norm_1, norm_2,
        spat_thresh, r_par_max, r_perp_max, x_max, y_max, one_over_x_incr,
        one_over_y_incr, x_incr, y_incr,
        norm1, norm2, min_dist;

  double s_sep[NDIM], sep[NDIM], r2_sep;
    int j1, j2, rdfType, j_mol, n;
    char *type_i, *type_j;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

  /* Read in input parameter file. */
  read_analyse_params(par_file, &header_file, &config_file, 
      &mass_file, &pot_file, 
      &n_species_chk, &excl_switch, 
      &n_cycles, &n_block, &n_trajec, &seed, &n_config,
      &n_dist, &n_r_par, &n_r_perp, &spat_thresh, &min_dist); 

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("n_cycles = %d, \n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);
  printf("seed = %ld\n",seed);
  printf("n_config %d n_dist %d n_r_par %d n_r_perp = %d spat_thresh %g\n", 
         n_config, n_dist, n_r_par, n_r_perp, spat_thresh);

  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);
  n_r_par = n_r_perp = 100;


  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &temp_atm_sigma, &temp_atm_eps,  &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field_pair(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

printf(" I am here\n");

  /* Allocate memory for arrays used in the builder. */

  allocate_memory_analyse(n_atoms, n_mols, n_species, 
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, &mol_coords, n_dist, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, n_atoms_per_mol, &exclusions,
      n_r_par, n_r_perp, &g_r, &g_1, &g_2, 
      &g_1_theta, &g_2_theta, &g_1_hist, &g_2_hist, 
      &g_r_par_perp, &g_1_par_perp, &g_2_par_perp,
      &mol_inert_mt, &mol_inert_axis);

printf(" I am here after allocate memory\n");

  /* Set up array of relative atom indices */
  relative_atoms_pair(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);
      

  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
   /* No of chromonic in the mixture */
  if (n_species > 2)
  n_mols1 = n_mols_per_species[0] + n_mols_per_species[1];
  else n_mols1 = n_mols_per_species[0];
  r_max = 10e6;

  /* Open trajectory files. */
   f_trajec = gfopen(config_file, "r");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);

  pos_1 = ftell(f_trajec);

  printf("Header from %s\n", config_file);
  printf("n_atoms = %d\n", n_atoms);
  printf("n_cycles = %d\n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);

  /* Compute number of instantaneous configuration in trajectory file. */
  if (n_cycles % n_trajec != 0) {
      printf("n_cycles must be a multiple of n_trajec\n");
      exit(1);
  }
  n_inst = n_cycles / n_trajec;
  count = 0;

  /* Allocate memory for box and atom coordinates. */
  h = allocate_2d_array(3, 3, sizeof(double));
  atom_coords = allocate_2d_array(8*n_atoms, 3, sizeof(double));

  /* Loop  over trajectories. */
  printf("\nEntering main loop\n");
  fflush(NULL);

      r_max = 13.1026;
      r_max = 0.5*r_max;
      r2_max = SQR (r_max);

   /* Choose r_par_max and r_perp_max so as to maximize sample volume. */
   r_par_max = r_max;
   r_perp_max = r_max;

   theta_max = 1;

   /* Calculate sizes of bins. */
   deltaR = r_max / n_dist;
   deltatheta = theta_max / n_dist;
   one_over_deltaR = 1.0 / deltaR;
   r_par_incr = 2.0 * r_par_max / n_r_par;
   one_over_r_par_incr = 1.0 / r_par_incr;
   r_perp_incr = r_perp_max / n_r_perp;
   one_over_r_perp_incr = 1.0 / r_perp_incr;


   printf(" deltaR %g\n", deltaR);


   /* Open trajectory files. */
   f_trajec = gfopen(config_file, "r");

   /* Position trajectory file pointer at beginning of first data set. */
   fseek(f_trajec, pos_1, 0);
    for (i_cycle = 0; i_cycle < n_inst; ++i_cycle) {

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);
      volume = h[0][0]*h[1][1]*h[2][2];

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }
       /* Compute molecular center of mass and relative "atom" coordinates. */
      center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

      /* Compute "bulk" correlations functions. */
      chromo_correlation(n_dist, deltaR,
         n_mols1, scaled_mol_coords, mol_inert_axis,
         h, g_1, g_2, &count, n_r_par, n_r_perp,
         one_over_deltaR, one_over_r_par_incr, one_over_r_perp_incr,
         g_r_par_perp, g_1_par_perp, g_2_par_perp, g_1_hist, g_2_hist,
         g_r, volume, r_par_max, min_dist, deltatheta, g_1_theta, 
         g_2_theta, mol_first_atm, scaled_atom_coords);


  } /* end of the loop. */
printf("count = %d, n_config %d\n", count, n_config);

  /* Close output file. */
  fclose(f_trajec);

/*   for (i_r = 0; i_r < n_dist; ++i_r) {
      r = (i_r + 0.5) * deltaR;
      printf("%g %g %g\n", r, g_1_hist[i_r], g_2_hist[i_r]);
   }
*/
  
  /* Normalize pair correlation functions. */

   norm1 = 1.0/count;
   printf (" norm1 %g\n", norm1);

   for (i_r = 0; i_r < n_dist; ++i_r) {
     g_1_hist[i_r] *= norm1;
     g_2_hist[i_r] *= norm1;
   }

   /* Write pair correlation functions to output files. */
   f_output = fopen("hist.dat", "w");
   for (i_r = 0; i_r < n_dist; ++i_r) {
      r = (i_r + 0.5) * deltaR;
      fprintf(f_output, "%g %g %g\n", r, g_1_hist[i_r], g_2_hist[i_r]);
   }

   fclose(f_output);

   for (i_r = 0; i_r < n_dist; ++i_r) {
     g_1_theta[i_r] *= norm1;
     g_2_theta[i_r] *= norm1;
   }

   /* Write pair correlation functions to output files. */
   f_output = fopen("angle.dat", "w");
   for (i_r = 0; i_r < n_dist; ++i_r) {
      r = (i_r + 0.5) * deltatheta;
      fprintf(f_output, "%g %g %g\n", r, g_1_theta[i_r], g_2_theta[i_r]);
   }

   fclose(f_output);


  /* Normalize pair correlation functions. */
   norm1 = 3.0 / (TWO_PI * n_mols1 * (n_mols1 - 1) * count);
   for (i_r = 0; i_r < n_dist; ++i_r) {
     r_1 = i_r * deltaR;
     r_2 = (i_r + 1) * deltaR;
     norm2 = norm1 / (CUBE(r_2) - CUBE(r_1));

     if (g_r[i_r] > 0.0) {
       g_1[i_r] /= g_r[i_r];
       g_2[i_r] /= g_r[i_r];
     }

     g_r[i_r] *= norm2;
printf(" norm1 %g norm2 %g i_r %d g_r %g n_mols1 %d\n", norm1, norm2, i_r, g_r[i_r],
             n_mols1);
    if (g_r[i_r] < spat_thresh) {
       g_1[i_r] = 0.0;
       g_2[i_r] = 0.0;
     }

   }

   /* Write pair correlation functions to output files. */
   f_output = fopen("a.g_r", "w");
   for (i_r = 0; i_r < n_dist; ++i_r) {
      r = (i_r + 0.5) * deltaR;
      fprintf(f_output, "%g %g %g %g\n", r, g_r[i_r], g_1[i_r], g_2[i_r]);
   }
   fclose(f_output);

   /* Normalize two-dimensional correlation functions. */
   norm1 = 1.0 / (PI * r_par_incr * n_mols1 * (n_mols1 - 1) * count);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp)
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par) {
         r_perp_1 = i_r_perp * r_perp_incr;
         r_perp_2 = (i_r_perp + 1) * r_perp_incr;
         norm2 = norm1 / (SQR(r_perp_2) - SQR(r_perp_1));
         if (g_r_par_perp[i_r_par][i_r_perp] > 0.0) {
            g_1_par_perp[i_r_par][i_r_perp] /= g_r_par_perp[i_r_par][i_r_perp];
            g_2_par_perp[i_r_par][i_r_perp] /= g_r_par_perp[i_r_par][i_r_perp];
         }
       g_r_par_perp[i_r_par][i_r_perp] *= norm2;
       if (g_r_par_perp[i_r_par][i_r_perp] < spat_thresh) {
          g_1_par_perp[i_r_par][i_r_perp] = 0.0;
          g_2_par_perp[i_r_par][i_r_perp] = 0.0;
       }
   }

   /* Write two-dimensional correlation functions to output files. */
   f_output = fopen("a.g_r_par_perp", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n", n_r_par, n_r_perp,
         - r_par_max, 0.0, r_par_incr, r_perp_incr);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) {
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par)
         fprintf(f_output, "%g ", g_r_par_perp[i_r_par][i_r_perp]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);
  f_output = fopen("a.g_1_par_perp", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n", n_r_par, n_r_perp,
         - r_par_max, 0.0, r_par_incr, r_perp_incr);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) {
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par)
         fprintf(f_output, "%g ", g_1_par_perp[i_r_par][i_r_perp]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

   f_output = fopen("a.g_2_par_perp", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n", n_r_par, n_r_perp,
         - r_par_max, 0.0, r_par_incr, r_perp_incr);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) {
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par)
         fprintf(f_output, "%g ", g_2_par_perp[i_r_par][i_r_perp]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);


  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_analyse(int n_atoms, int n_mols, int n_species,
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, 
double ***mol_coords, int n_r, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, int *n_atoms_per_mol,int ****exclusions, 
int n_r_par, int n_r_perp,
double **g_r, double **g_1, double **g_2, 
double **g_1_theta, double **g_2_theta, double **g_1_hist,
double **g_2_hist, double ***g_r_par_perp, double ***g_1_par_perp,
double ***g_2_par_perp, double ***mol_inert_mt, double ****mol_inert_axis)

{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }
   *g_r = allocate_1d_array(n_r, sizeof(double));
   *g_1 = allocate_1d_array(n_r, sizeof(double));
   *g_2 = allocate_1d_array(n_r, sizeof(double));
   *g_1_theta = allocate_1d_array(n_r, sizeof(double));
   *g_2_theta = allocate_1d_array(n_r, sizeof(double));
   *g_1_hist = allocate_1d_array(n_r, sizeof(double));
   *g_2_hist = allocate_1d_array(n_r, sizeof(double));
   *g_r_par_perp = allocate_2d_array(n_r_par, n_r_perp, sizeof(double));
   *g_1_par_perp = allocate_2d_array(n_r_par, n_r_perp, sizeof(double));
   *g_2_par_perp = allocate_2d_array(n_r_par, n_r_perp, sizeof(double));
   *mol_inert_mt = allocate_2d_array(n_mols, 3, sizeof(double));
   *mol_inert_axis = allocate_3d_array(n_mols, 3, 3, sizeof(double));
}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms_pair(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
