/* Spatial correlation function routines. */

#include "build.h"

/* Calculate center of mass pair correlation functions. */
void chromo_correlation(int n_dist, double deltaR, 
   int n_mol, double **scaled_mol_coords, double ***mol_inert_axis, 
   double **h, double *g_1, double *g_2, int *count, int n_r_par, int n_r_perp,
   double one_over_r_incr, double one_over_r_par_incr, double one_over_r_perp_incr,
   double **g_r_par_perp, double **g_1_par_perp, double **g_2_par_perp,
   double *g_1_hist, double *g_2_hist, double *g_r, double volume,
   double r_par_max, double min_dist, double deltatheta, double *g_1_theta,
   double *g_2_theta)

{
   int i_mol, j_mol, i_r, par_bin, perp_bin, k, i_r_par, i_r_perp,
       i_theta1, i_theta2;
   double r2, r, r_par, r_perp,
      u_i_dot_u_j, pu_i_dot_pu_j, p_1, p_2, s_sep[3], sep[3],
      pu_i[3], pu_j[3], u_i[3], u_j[3], p_1_theta, p_2_theta;

   /* Loop over all pairs of molecules. */
   for (i_mol = 0; i_mol < n_mol - 1; ++i_mol)
      for (j_mol = i_mol + 1; j_mol < n_mol; ++j_mol) {
       

       /* Calculate separation of molecules i_mol and j_mol. */
       for (k = 0; k < 3; ++k){
          s_sep[k] = scaled_mol_coords[i_mol][k] - scaled_mol_coords[j_mol][k]; 
          s_sep[k] -= NINT(s_sep[k]);
          sep[k] = s_sep[k] * h[k][k];
       }

       r2 = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);

          /* Calculate separation of molecules i_mol and j_mol. */
          r = sqrt(r2);

       /* Test whether squared pair separation is within cutoff. */
        if (fabs(r - min_dist) < 1e-03){ 
            
          *count +=1;
          printf(" No. of minimum Energy. config found: %d\n", *count);

          /* Calculate molecular directors for molecules i_mol and j_mol,
          as well as Legendre polynomials of their dot product. */

          pu_i[0] = mol_inert_axis[i_mol][1][0];
          pu_i[1] = mol_inert_axis[i_mol][1][1];
          pu_i[2] = mol_inert_axis[i_mol][1][2];

          pu_j[0] = mol_inert_axis[j_mol][1][0];
          pu_j[1] = mol_inert_axis[j_mol][1][1];
          pu_j[2] = mol_inert_axis[j_mol][1][2];

          u_i[0] = mol_inert_axis[i_mol][2][0];
          u_i[1] = mol_inert_axis[i_mol][2][1];
          u_i[2] = mol_inert_axis[i_mol][2][2];

          u_j[0] = mol_inert_axis[j_mol][2][0];
          u_j[1] = mol_inert_axis[j_mol][2][1];
          u_j[2] = mol_inert_axis[j_mol][2][2];

/*          for (k = 0; k < NDIM; ++k)
                printf("pu_i[%d] = %g, u_i[%d] = %g\n", k, pu_i[k], k, u_i[k]); */

          p_1 = pu_i[0] * pu_j[0] + pu_i[1] * pu_j[1] + pu_i[2] * pu_j[2];
          u_i_dot_u_j = u_i[0] * u_j[0] + u_i[1] * u_j[1] + u_i[2] * u_j[2];
          p_2 = 1.5 * SQR(u_i_dot_u_j) - 0.5;
          p_1_theta = sqrt(SQR(p_1));
          p_2_theta= sqrt(SQR(u_i_dot_u_j));


          /* Add contributions to molecular translational and orientational
             correlation functions. */

          i_r = (int) (r /deltaR);
          i_theta1 = (int) (p_1_theta/deltatheta);
          i_theta2 = (int) (p_2_theta/deltatheta);

          if (i_r < n_dist) {
          /*     printf(" i_r %d g_r %g\n", i_r, g_r[i_r]);  */
               g_r[i_r] += volume;
               g_1[i_r] += volume * p_1 ;
               g_2[i_r] += volume * p_2 ;
               g_1_theta[i_theta1] += 1 ;
               g_2_theta[i_theta2] += 1 ;
          }

          /* Calculate components of displacement of molecule j_mol relative to
          molecule i_mol parallel and perpendicular to director of molecule i_mol. */

          r_par = sep[0] * u_i[0] + sep[1] * u_i[1] + sep[2] * u_i[2];
          r_perp = sqrt(r2 - SQR(r_par));

         /* Build the histogram for r_par and r_perp */
          par_bin = (int) (sqrt(SQR(r_par)) / deltaR) + 1;
          perp_bin = (int) (r_perp / deltaR) + 1;

          if (par_bin < n_dist && perp_bin < n_dist) {
             g_1_hist[par_bin] +=1;
             g_2_hist[perp_bin] +=1;
          }

          /* Add contributions to two-dimensional correlation functions. */

          i_r_par = FLOOR((r_par + r_par_max) * one_over_r_par_incr);
          i_r_perp = (int) (r_perp * one_over_r_perp_incr);
          if (i_r_par >= 0 && i_r_par < n_r_par && i_r_perp < n_r_perp) {
             g_r_par_perp[i_r_par][i_r_perp] += volume;
             g_1_par_perp[i_r_par][i_r_perp] += volume * p_1;
             g_2_par_perp[i_r_par][i_r_perp] += volume * p_2;
          }

          /* Calculate components of displacement of molecule i_mol relative to
          molecule j_mol parallel and perpendicular to director of molecule j_mol. */

          r_par = - sep[0] * u_j[0] - sep[1] * u_j[1] - sep[2] * u_j[2];
          r_perp = sqrt(r2 - SQR(r_par));

          /* Add contributions to two-dimensional correlation functions. */

          i_r_par = FLOOR((r_par + r_par_max) * one_over_r_par_incr);
          i_r_perp = (int) (r_perp * one_over_r_perp_incr);
          if (i_r_par >= 0 && i_r_par < n_r_par && i_r_perp < n_r_perp) {
             g_r_par_perp[i_r_par][i_r_perp] += volume;
             g_1_par_perp[i_r_par][i_r_perp] += volume * p_1;
             g_2_par_perp[i_r_par][i_r_perp] += volume * p_2;
          }
       } 
     }

}
