/* Periodic boundary condition nonbonded force routines for molecular
   modeling package, with WCA form for vdW interactions. */

#include "build.h"

/* Calculate short-range WCA interactions using a cell search with phantom
   cells. */

void wca_period_phantom(int *mol_species, int *atom_rel, int *atom_mol, 
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions, 
   int **comb_pot, double ***comb_par, double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, double gamma, 
   double three_gamma_over_two, double two_over_gamma_cubed, 
   double *pe_vdw_s, int period_switch, int *first, int *last, 
   phantom_cell *phantoms, int noffsets, int *nc_p, int kc, int *phantom_skip, 
   int *nc, atom_cell *atom_cells, int *offsets, double **atom_coords, 
   double **rel_atom_coords, double **at_stress_vdw_s, 
   double **mol_stress_vdw_s, double **f_vdw_s)
{
   int i, j, k, i_species, j_species, i_mol, j_mol, i_rel, j_rel, inter_flag;
   double s_sep[NDIM], sep[NDIM], r2_sep, u_vdw, 
      s_i[NDIM], l_range[NDIM], shift[NDIM];
   int in_plane, icxy, icx, icy, icz, jcx, jcy, jcz, jc, i_off;
   int ic, j_real, pot_form, i_type, j_type, compute_flag;
   double p_norm, volume, rel_dist[NDIM], f_i_vdw[NDIM], fvdw, f_vdw[NDIM];
   int counter;

   /* Initialisation. */
   *pe_vdw_s = 0.0;

   /* Zero short-range vdW forces. */
   for (i = 0; i < n_atoms; ++i)
      for (k = 0; k < NDIM; ++k)
         f_vdw_s[i][k] = 0.0;

   for (i = 0; i < NDIM; ++i)
      for (k = 0; k < NDIM; ++k)
         mol_stress_vdw_s[i][k] = 0.0;
   
   /* Loop over atoms. */
   for (i = 0; i < n_atoms ; ++i) {

      /* Get attributes of atom i. */
      for (k = 0; k < NDIM; ++k){
        s_i[k] = atom_coords[i][k];
        f_i_vdw[k] = 0.0;  
       }
      
      i_mol = atom_mol[i];
      i_rel = atom_rel[i];
      i_type = atom_type[i];
      i_species = mol_species[i_mol];

      /* Get cell index. */
      ic = atom_cells[i].cell;

      for (i_off = 0; i_off < noffsets; ++i_off) {

         /* Compute index of neighboring cell and get index of the
            first atom in that cell. */
         jc = ic + offsets[i_off];
         j = first[jc];

         counter = 0;
         /* Loop over atoms in neighboring cell. */
         while (j != -1) {

         ++counter;
         if (counter > 5000) 
           error_exit("pb with do-while loop wca_period.");

         /* Get attributes of atom j. */
         j_real = atom_cells[j].real;
         j_mol = atom_mol[j_real];
         j_rel = atom_rel[j_real];
         j_type = atom_type[j_real];
     
         /* Determine whether interaction should be computed. */
         inter_flag = i_mol != j_mol;
         if (inter_flag || exclusions[i_species][i_rel][j_rel]) {

               /* Calculate scaled pair separation. */
               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];

               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);
               
               /* Calculate specie of the j atom. */
               j_species = mol_species[j_mol];

               /* Get the pair interaction form. */
               pot_form = comb_pot[i_type][j_type];
               compute_flag = 0;
/****************************************************************************/
/********************** Begin of pair interaction menu. *********************/
/****************************************************************************/
               /* Compute pair interaction. */
               compute_pot(i_type, j_type, pot_form, r2_off, r2_on, r2_sep, 
                  comb_par, gamma, three_gamma_over_two, two_over_gamma_cubed,
                  &u_vdw, &fvdw, &compute_flag);

               if (compute_flag) {

               /* Add contributions to potential energy and atomic and
                  molecular pressure tensors. */
               *pe_vdw_s += u_vdw;

               /* Add contributions to force. */
               for ( k = 0; k < NDIM; ++k){
                 f_vdw[k] = sep[k] * fvdw;
                 f_i_vdw[k] -= f_vdw[k];
               }
               
               /* Compute stress tensor. */
               mol_stress_vdw_s[0][0] += sep[0] * f_vdw[0];
               mol_stress_vdw_s[1][1] += sep[1] * f_vdw[1];
               mol_stress_vdw_s[2][2] += sep[2] * f_vdw[2];
               mol_stress_vdw_s[0][1] += sep[0] * f_vdw[1];
               mol_stress_vdw_s[0][2] += sep[0] * f_vdw[2];
               mol_stress_vdw_s[1][2] += sep[1] * f_vdw[2];

               /* Add contribution coming from the intramolecular 
                  rigidity constraint */
               for ( k =0; k<NDIM; ++k)
                  rel_dist[k] = (rel_atom_coords[j_real][k] - 
                                                 rel_atom_coords[i][k]);

               mol_stress_vdw_s[0][0] -= rel_dist[0] * f_vdw[0];
               mol_stress_vdw_s[1][1] -= rel_dist[1] * f_vdw[1];
               mol_stress_vdw_s[2][2] -= rel_dist[2] * f_vdw[2];
               mol_stress_vdw_s[0][1] -= rel_dist[0] * f_vdw[1];
               mol_stress_vdw_s[0][2] -= rel_dist[0] * f_vdw[2];
               mol_stress_vdw_s[1][2] -= rel_dist[1] * f_vdw[2];
               }

/****************************************************************************/
/************************ End of pair interaction menu. *********************/
/****************************************************************************/
               }
            j = atom_cells[j].next;
            }
	}
      for ( k = 0; k < NDIM; ++k)
       f_vdw_s[i][k] = f_i_vdw[k];
   }

/* The contributions to the potential and to the stress tensor are half
   the previous quantities (we have computed i on j and j on i). */

   *pe_vdw_s /= 2.0;
    
   for (i = 0; i < NDIM; ++i)
     for (j = i; j < NDIM; ++j)
       mol_stress_vdw_s[i][j] /= 2.0;
}
/****************************************************************************/
/* Calculate short-range LJ interactions between the molecule i_mol and all the
others, using a N^2 search, and using a switching function to truncate the pair
potential and pair force smoothly. */

void wca_period_single_phantom(int skip, int mol, int *mol_species, 
   int *atom_rel, int *atom_mol, int *atom_type, int n_atoms, 
   int *n_atoms_per_mol, int ***exclusions, 
   int **comb_pot, double ***comb_par,  double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, 
   double gamma, double three_gamma_over_two, double two_over_gamma_cubed, 
   double *pe_vdw_s_single,
   int period_switch, int *first, int *last, phantom_cell *phantoms, 
   int noffsets, int *nc_p, int kc, int *phantom_skip, int *nc,
   atom_cell *atom_cells, int *offsets, 
   double **atom_coords, int *mol_first_atm)
{
   int i, j, k, i_species, j_species, i_mol, j_mol, i_rel, j_rel, inter_flag,
      i_type, j_type;
   double s_sep[NDIM], sep[NDIM], r2_sep, u_vdw, fvdw, 
      s_i[NDIM], l_range[NDIM], shift[NDIM];
   int in_plane, icxy, icx, icy, icz, jcx, jcy, jcz, jc, i_off;
   int ic, j_real, pot_form, compute_flag;
   int counter;

   /* Initialisation. */
   *pe_vdw_s_single = 0.0;

   i_species = mol_species[mol];
   /* Loop over atoms in the molecule i_mol. */
   for (i = skip; i < skip + n_atoms_per_mol[i_species] ; ++i) {

      /* Get attributes of atom i. */
      for (k = 0; k < NDIM; ++k)
        s_i[k] = atom_coords[i][k];
      i_mol = atom_mol[i];
      i_rel = atom_rel[i];
      i_type = atom_type[i];

     /* Get cell index. */
      ic = atom_cells[i].cell;

      for (i_off = 0; i_off < noffsets; ++i_off) {

            /* Compute index of neighboring cell and get index of the
               first atom in that cell. */
            jc = ic + offsets[i_off];
            j = first[jc];

       counter = 0;
       /* Loop over atoms in neighboring cell. */
         while (j != -1) {

         ++counter;
         if (counter > 5000) 
           error_exit("pb with do-while loop wca_period_single.");

         /* Get attributes of atom j. */
         j_real = atom_cells[j].real;
         j_mol = atom_mol[j_real];
         j_rel = atom_rel[j_real];
         j_type = atom_type[j_real];

         /* Determine whether interaction should be computed. */
         inter_flag = i_mol != j_mol;
         if (inter_flag || exclusions[i_species][i_rel][j_rel]) {

               /* Calculate scaled pair separation. */
               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];
                 
               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);

               /* If the pair separation is less than r_off, calculate
                  vdW interaction. */
               j_species = mol_species[j_mol];

               /* Get the pair interaction form. */
               pot_form = comb_pot[i_type][j_type];
               compute_flag = 0;

/****************************************************************************/
/********************** Begin of pair interaction menu. *********************/
/****************************************************************************/
               /* Compute pair interaction. */
               compute_pot(i_type, j_type, pot_form, r2_off, r2_on, r2_sep, 
                  comb_par, gamma, three_gamma_over_two, two_over_gamma_cubed,
                  &u_vdw, &fvdw, &compute_flag);

               if (compute_flag)
               /* Add contributions to potential energy and atomic and
                  molecular pressure tensors. */
               *pe_vdw_s_single += u_vdw;
/****************************************************************************/
/************************ End of pair interaction menu. *********************/
/****************************************************************************/
	      }
              j = atom_cells[j].next;
            }
          }
	}
}
/****************************************************************************/
