/* Weighted histogram analysis routines. */

#include "build.h"
#include "ff.h"
#include "proto.h"

#define TOL 1.0e-5

int main(int argc, char *argv[])
{
   FILE *f_param, *f_hist, *f_free, *f_prob;
   char *param_file, **hist_file;
   int i, j, n_mol, n_mol_prev, n_bins, n_bins_prev, n_files, i_bin, keep_going,
      *n_samples, n_r;
   double pi, deviation, energy, numerator, denominator, ratio,
      change, rel_change, param, param_min, param_max,
      param_min_prev, param_max_prev, param_incr,
      *prob, *prob_unc, *free, *free_unc, corr_time, *corr_fact,
      *z, *z_new, *param_eq, *k_bias, **weight, range, deltaR, norm1,
      **g_r_hist, **g_1_hist, **g_2_hist, *g_r, *g_1, *g_2,
      norm1_prev, deltaR_prev, r_1, r_2, norm2, spat_thresh = 0.1;

   /* Get command-line input, which consists of the name of the file
      containing input parameters. */
   if (argc != 2) {
      fprintf(stderr, "Usage: %s param_file\n", argv[0]);
      exit(1);
   }
   param_file = gmalloc((strlen(argv[1])+1) * sizeof(char));
   strcpy(param_file, argv[1]);

   printf("\nWeighted histogram analysis program\n");
   fflush(NULL);

   /* Read default parameters from defaults file. */
   f_param = gfopen(param_file, "r");
   fscanf(f_param, "%d\n", &n_files);
   hist_file = allocate_2d_array(n_files, F_MAX + 1, sizeof(char));
   for (i = 0; i < n_files; ++i) {
      fscanf(f_param, "%s\n", hist_file[i]);
   }
   fclose(f_param);

   /* Read number of molecules and number of bins from first histogram file. */
   f_hist = gfopen(hist_file[0], "r");
   fscanf(f_hist, "%lf %d %lf\n", &norm1, &n_bins, &deltaR);
   fclose(f_hist);
   printf("%g  %d %g\n", norm1, n_bins, deltaR);

   /* Allocate memory for various arrays. */
   n_samples = allocate_1d_array(n_files, sizeof(int));
   g_r_hist = allocate_2d_array(n_files, n_bins, sizeof(double));
   g_1_hist = allocate_2d_array(n_files, n_bins, sizeof(double));
   g_2_hist = allocate_2d_array(n_files, n_bins, sizeof(double));
   g_r = allocate_1d_array(n_bins, sizeof(double));
   g_1 = allocate_1d_array(n_bins, sizeof(double));
   g_2 = allocate_1d_array(n_bins, sizeof(double));

   /* Read in histograms and calculate weights. */
   for (i = 0; i < n_files; ++i) {
      f_hist = gfopen(hist_file[i], "r");

      n_bins_prev = n_bins;
      norm1_prev = norm1;
      deltaR_prev = deltaR;

      fscanf(f_hist, "%lf %d %lf\n", &norm1, &n_bins, &deltaR);
      printf("%g  %d %g\n", norm1, n_bins, deltaR);

      if (n_bins != n_bins_prev) {
         fprintf(stderr, "Mismatch in n_bins\n");
         exit(1);
      }

      if (norm1 != norm1_prev) {
         fprintf(stderr, "Mismatch in norm1\n");
         exit(1);
      }
      if (deltaR != deltaR_prev) {
         fprintf(stderr, "Mismatch in deltaR\n");
         exit(1);
      }

      for (i_bin = 0; i_bin < n_bins; ++i_bin) {
      fscanf(f_hist, "%d %lf %lf %lf\n", &n_r, &g_r_hist[i][i_bin], &g_1_hist[i][i_bin],
                             &g_2_hist[i][i_bin]);
      }
      fclose(f_hist);
   }
  printf(" I am here\n");
      fflush(NULL);

      /* Loop over bins. */

     for (i_bin = 0; i_bin < n_bins; ++i_bin) {
      for (j = 0; j < n_files; ++j) {
            g_r[i_bin] += g_r_hist[j][i_bin];
            g_1[i_bin] += g_1_hist[j][i_bin];
            g_2[i_bin] += g_2_hist[j][i_bin];
         }
      }

   for (i_bin = 0; i_bin < n_bins; ++i_bin) {
     r_1 = i_bin * deltaR;
     r_2 = (i_bin + 1) * deltaR;
     norm2 = norm1 / (CUBE(r_2) - CUBE(r_1));
     if (g_r[i_bin] > 0.0) {
       g_1[i_bin] /= g_r[i_bin];
       g_2[i_bin] /= g_r[i_bin];
     }
     g_r[i_bin] *= norm2;
     if (g_r[i_bin] < spat_thresh) {
       g_1[i_bin] = 0.0;
       g_2[i_bin] = 0.0;
     }
   }

   printf(" I am here \n");

   /* Write results to output files. */
   f_free = gfopen("g_r.wham", "w");
   for (i_bin = 0; i_bin < n_bins; ++i_bin) {
         param = (i_bin + 0.5) * deltaR;
         fprintf(f_free, "%g %g %g %g\n", param, g_r[i_bin], g_1[i_bin], g_2[i_bin]);
   }
   fclose(f_free);

   exit(0);
}

#undef TOL
