/* "Graceful" routines for opening files. */

#include "build.h"

/* Graceful fopen routine. */
FILE *gfopen(const char *file_name, const char *type)
{
   FILE *ptr;

   if ((ptr = fopen(file_name, type)) == NULL) {
      fprintf(stderr, "Cannot open %s in gfopen\n", file_name);
      exit(1);
   }

   return ptr;
}
