/* Routines for assigning molecules to smectic layers. */

#include "build.h"

/* layer_assignment calculates the smectic layer index
for a single molecule.

input: number of layers (n_layers)
       scaled molecular position (s)

output: layer index (return value) */

int layer_assignment(int n_layers, double *s)
{
   int layer;

   /* Calculate layer index for molecule. */
   layer = (int) (n_layers * (s[2] + 0.5));
   if (layer == n_layers) layer = 0;

   /* Return layer index. */
   return layer;
}
