
#include "build.h"

/* parse_tokens parses a string containing tokens separated by spaces,
   and returns the number of tokens and an array of strings containing 
   the tokens. */

int parse_tokens(char *line, char ***token)
{
   int n_tokens = 0;
   char *token_tmp;

   token_tmp = strtok(line, " \n");
   while (token_tmp != NULL) {
      (*token) = grealloc((*token), (n_tokens+1) * sizeof(char*));
      (*token)[n_tokens] = gmalloc((strlen(token_tmp)+1) * sizeof(char));
      strcpy((*token)[n_tokens], token_tmp);
      ++n_tokens;
      token_tmp = strtok(NULL, " \n");
   }

   return n_tokens;
}
