/* Functions declaration */
void read_mass_params(char *mass_file, mass_entry **mass, int *n_mass);

void set_up_force_field(int n_species, int n_mols, int *n_atoms_per_mol,
     int n_mass, mass_entry *mass, int *mol_species, int *n_bonds_per_mol,
     double ***temp_atm_mass, char ***temp_atm_type, double **mol_mass,
     double **mol_mass_true, int **mol_first_atm);



void ordering_tensor(int n_mols, double **u, double **q);
void update_ordering_tensor(int n_mols, double **u,
                            int i_mol, double *u_new, double **q);
void eigenvalues(double **q, double *lambda, double **v);

/* Routines in overlap.c */
int overlap(double *s1, double *u1, double *s2, double *u2,
            int sphero1, int sphero2, double *length, double skin, double **h);

/* Routines in nr.c */
void jacobi(double **a, int n, double d[], double **v, int *nrot);
void eigsrt(double d[], double **v, int n);
double ran3(long *idum);

/* Routines in utilities.c */
double *assign_vector(double *v, int n);
double *vector_sum(double *v1, double *v2, int n);
double *vector_difference(double *v1, double *v2, int n);
double magnitude(double *v, int n);
double *scale_vector(double *v, int n, double scale_factor);
double dot_product(double *v1, double *v2, int n);

/* Routines in mc_moves.c */
void mc_cycle(int n_mols, int n_reshape, double length1, double length2, double skin,
              double **h, double **h_inv, double dr_max, double *ds_max,
              double du_max,
              int reshape_axis, double dside_max, long *i_ran,
              nl_entry **nl_head, nl_entry **nl_tail, double **dr_tot,
              double **dr_opt,
              double **mol_coords, double **scaled_mol_coords,
              double **scaled_mol_unfolded, double **atom_coords,
              double **scaled_atom_coords, double **rel_atom_coords,
              double **mol_coords_trial, double **atom_coords_trial,
              double **scaled_atom_coords_trial, double **s_sphero_trial,
              int *mol_first_atm, 
              int *n_atoms_per_mol, double **s_sphero, double **u_sphero, 
              int *mol_first_sphero, int *n_bonds_per_mol, int *sphero_mol,
              int cell_switch, double pressure, double *volume,
              int *n_mol_moves, int *n_mol_accept, int *n_reshape_moves,
              int *n_reshape_accept, int *mol_species, int n_atoms,
              int n_sphero, double *length, double **disp);

int molecule_move(int i_mol, int n_mols, double skin,
                  double **h, double **h_inv, double dr_max,
                  double du_max, long *i_ran,
                  nl_entry **nl_head, nl_entry **nl_tail, double **dr_tot,
                  double **dr_opt, double **mol_coords,
                  double **scaled_mol_coords, double **scaled_mol_unfolded,
                  double **atom_coords, double **scaled_atom_coords,
                  double **atom_coords_trial, double **scaled_atom_coords_trial,
                  int *mol_first_atm, int *n_atoms_per_mol,
                  double **rel_atom_coords, double **s_sphero,
                  double **u_sphero, int *mol_first_sphero,
                  int *n_bonds_per_mol, int *sphero_mol, int *mol_species,
                  int n_atoms, int n_sphero, double *length);

int reshape_move(int n_mols, int cell_axis, double length1, double length2, double skin,
                 double **h, double **h_inv, double dside_max,
                 double dr_max, double *ds_max, long *i_ran,
                 nl_entry **nl_head, nl_entry **nl_tail,
                 double **dr_tot, double **dr_opt, double **mol_coords,
                 double **scaled_mol_coords, double **scaled_mol_unfolded,
                 double **atom_coords, double **scaled_atom_coords,
                 double **mol_coords_trial, double **atom_coords_trial,
                 double **scaled_atom_coords_trial, double **s_sphero_trial,
                 int *mol_first_atm, int *n_atoms_per_mol,
                 double **rel_atom_coords, double **s_sphero,
                 double **u_sphero, int *mol_first_sphero,
                 int *n_bonds_per_mol, int *sphero_mol, int *mol_species,
                 int n_sphero, int n_atoms, double *length);

int volume_move(int n_mols, int cell_axis, double length1, double length2,
                double skin,
                double **h, double **h_inv, double dside_max,
                double dr_max, double *ds_max, double pressure, double *volume,
                long *i_ran, nl_entry **nl_head, nl_entry **nl_tail,
                double **dr_tot, double **dr_opt, double **mol_coords,
                double **scaled_mol_coords, double **scaled_mol_unfolded,
                double **atom_coords, double **scaled_atom_coords,
                double **mol_coords_trial, double **atom_coords_trial,
                double **scaled_atom_coords_trial, double **s_sphero_trial,
                int *mol_first_atm, int *n_atoms_per_mol,
                double **rel_atom_coords, double **s_sphero,
                double **u_sphero, int *mol_first_sphero,
                int *n_bonds_per_mol, int *sphero_mol, int *mol_species,
                int n_atoms, int n_sphero, double *length, double **disp);

/* Routines in phase.c */
void modulated_directors(int n_mol, int n_layers, double dphi,
                         double **s, double **u, double **u_mod);
void single_modulated_director(int n_layers, double dphi,
                               double *s, double *u, double *u_mod);

/* Routines in tilt_biasing_potential.c */
double tilt_biasing_potential(int n_mol, double k_theta, double cos_theta_equil,
                              double **u, double **q, double *lambda, double **v);

/* Routines in layers.c */
int layer_assignment(int n_layers, double *s);

/* Routines in neighbors.c */
void update_neighbor_lists(int n_mols, double *length, 
                           double skin, double **h,
                           double **s_sphero, double **u_sphero,
                           nl_entry **nl_head, nl_entry **nl_tail,
                           int n_sphero, int *sphero_mol,
                           double **dr_tot, double **scaled_mol_coords,
                           double **scaled_mol_unfolded, int n_atoms);

/* Routines in graphics.c */
void read_set_up_color(char *color_file, type_entry *atm_type, int n_type,
   int **comb_col);

void initialize(Display **dpy, Window *win, GLboolean doubleBuffer,
                GLUquadricObj **qobj, int graph_switch, int antialias_switch,
                double **h);

void redraw(Display *dpy, Window win, GLboolean doubleBuffer,
    GLUquadricObj *qobj, int graph_switch, int n_mols, int *mol_species,
    int *mol_first_atm, int *n_atoms_per_mol, int *n_bonds_per_mol,
    double **mol_coords, double **rel_atom_coords,
    double **h, int **temp_bonds_1, int **temp_bonds_2, int species_choice,
    int *atom_type, int *comb_col, int resph, double radius_sph,
    double radius_cyl, short *keep_going);

/* Routines in cpu.c */
double cpu(void);

/* Routines in optimize.c */
double compute_efficiency(int n_atoms, double *opt_time, double **dr_opt);

void optimize_molecule_moves(int n_atoms, double **h, double *dr_max, 
                             double *dr_max_old, double *ds_max, 
                             double *du_max, double ratio_du_dr,
                             double *opt_time, double *efficiency, 
                             double **dr_opt);

void optimize_ratio(int n_atoms, double **h, double dr_max, double *du_max,
                    double *ratio_du_dr, double *ratio_du_dr_old,
                    double *opt_time, double *efficiency, double **dr_opt);

void optimize_reshape_moves(double **h, double reshape_accept_rate, 
                            double *dside_max);

void optimize_skin(int n_mols, double **h, double *skin,
                   double *skin_old, double *opt_time, double *efficiency,
                   double **dr_opt, double **s_sphero, double **u_sphero,
                   nl_entry **nl_head, nl_entry **nl_tail, double **dr_tot,
                   double **scaled_mol_coords, double **scaled_mol_unfolded,
                   int *n_bonds_per_mol, int *sphero_mol, int n_atoms,
                   int n_sphero, double *length);


/* Routines in parse_tokens.c */
int parse_tokens(char *line, char ***token);

/* Routines in io_utilities.c */
FILE *gfopen(const char *file_name, const char *type);

/* Routines in parse_params.c */
void parse_params(char *param_file, char **header_file, char **config_file,
                  char **mass_file, char **color_file,
                  char **header_file_save, char **config_file_save,
                  double *pressure_star,
                  int *n_layers, double *layer_spacing, double *skin,
                  double *dr_max, double *ratio_du_dr, double *dside_max,
                  int *reshape_axis, int *n_reshape, int *bias_switch,
                  int *cell_switch,
                  double *k_theta, double *theta_equil, double *dphi,
                  double *k_displ, double *rms_displ_equil,
                  int *displ_flag, double *displ_max,
                  int *n_cycles, int *n_block, int *n_thermo, int *n_trajec,
                  int *opt_switch, int *n_opt,
                  int *n_cos_theta, int *n_rms_displ,
                  int *graph_switch, int *n_graph,
                  long *i_ran, double *tilt_angle, int *end_vec_switch,
                  double *radius_sph, double *radius_cyl, int *resph,
                  int *antialias_switch, int *species_choice);

/* Routines in reading and writing config files */
void write_config_direct(char *config_file, double **h,
   int n_atoms, double length1, double length2, double dr_max, double ratio_du_dr,
   double dside_max, double skin, double **atom_coords);


void read_config_direct(char *config_file, double ***h,
        int n_atoms, double *length1, double *length2, double *dr_max,
        double *ratio_du_dr,
        double *dside_max, double *skin, double ***atom_coords);

/* Routines in statistics.c */
void statistics(int nb, double *x, double *xave, double *xunc);

/* Routines in rms_displ.c */
double compute_rms_displ(int n_layers, int n_mol, double s0, double *side, double **s);
void layer_position(int n_layers, int n_mol, double *side, double **s, double *s0);

/* Routines tocalculate scaled coordinates */
void scaled_atomic_coords_single(int i_mol, int *n_atoms_per_mol,
       int *mol_first_atm, int *mol_species, double **h_inv,
       double **atom_coords, double **scaled_atom_coords);

void periodic_boundary_conditions_single(int i_mol, int *n_atoms_per_mol,
       int *mol_first_atm, int *mol_species, double **h,
       double **atom_coords, double **scaled_atom_coords);

void scaled_atomic_coords(int n_atoms, double **h_inv, double **atom_coords,
   double **scaled_atom_coords);

void periodic_boundary_conditions(int n_atoms, double **h,
   double **scaled_atom_coords, double **atom_coords);

void box_dimensions(double **h, double **h_inv);

void center_of_mass_positions(int period_switch, int n_mols, int n_species,
  int *n_atoms_per_mol, int *mol_species, double *atom_mass,
  int *mol_first_atm, double **atom_coords, double **scaled_atom_coords,
  int **scan_atm_1, int **scan_atm_2, double *mol_mass, double **h,
  double **h_inv, double **mol_coords, double **scaled_mol_coords,
  double **rel_atom_coords, int *n_bonds_per_mol, double ***corr);

void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type);

void center_of_sphero(int n_mols, int *mol_first_atm, double **h,
   double *length, double **scaled_atom_coords,
   int *mol_first_sphero,
   double **s_sphero, double **u_sphero, int *mol_species, int *n_bonds_per_mol);

void end_to_end_vector(int n_mols, int *mol_first_atm, double **h,
   double length, double **scaled_atom_coords, double **end_sphero,
   double **polar_sphero, double tilt_angle);

void inertia_tensors(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double *atom_mass, double *mol_mass,
   double **rel_atom_coords, double **mol_inert_mt, double ***mol_inert_axis);

void nematic_order(int n_mols, int n_species, int *mol_species,
  int *n_mols_per_species, double ***mol_inert_axis, double ***mol_order_inst,
  double **lambda, double ***v);


