/* Tilt biasing potential routine for spherocylinder MC program */

#include "shared.h"

/* tilt_biasing_potential calculates the biasing potential for a
   molecular director configuration specified by u.

input: number of molecules (n_mol)
       strength of tilt biasing potential (k_bias)
       position of minimum for tilt biasing potential (cos_theta_equil)
       array of molecular directors (u)

output: ordering tensor (q)
        eigenvalues of ordering tensor (lambda)
        eigenvectors of ordering tensor (v)
        biasing potential (return value) */

double tilt_biasing_potential(int n_mol, double k_theta, double cos_theta_equil,
                              double **u, double **q, double *lambda, double **v)
{
   double e_bias, deviation;

   /* Calculate ordering tensor. */
   ordering_tensor(n_mol, u, q);

   /* Calculate eigenvalues and eigenvectors of ordering tensor. */
   eigenvalues(q, lambda, v);

   /* Compute energy of new configuration. */
   deviation = ABS(v[2][0]) - ABS(cos_theta_equil);
   e_bias = 0.5 * k_theta * SQR(deviation);

   /* Return biasing potential. */
   return e_bias;
}
