
/* Include header files for system libraries. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>

/* Macro definitions. */
#define SQR(x)             ((x) * (x))
#define CUBE(x)            ((x) * (x) * (x))
#define ABS(x)             ((x) < 0 ? -(x) : (x))
#define MAX(x,y)           ((x) > (y) ? (x) : (y))
#define MIN(x,y)           ((x) < (y) ? (x) : (y))
#define SIGN(a,b)          ((b) > 0.0 ? fabs(a) : -fabs(a))
#define NINT(x)            ((x) < 0.0 ? (int) ((x) - 0.5) : (int) ((x) + 0.5))
#define ROTATE(a,i,j,k,l)  g=a[i][j];h=a[k][l];a[i][j]=g-s*(h+g*tau);\
                           a[k][l]=h+s*(g-h*tau);

/* Routines in allocate.c */
void *allocate_1d_array(size_t n, size_t size);
void **allocate_2d_array(size_t n1, size_t n2, size_t size);
void ***allocate_3d_array(size_t n1, size_t n2, size_t n3, size_t size);
void ****allocate_4d_array(size_t n1, size_t n2, size_t n3, size_t n4, size_t size);
void free_1d_array(void *ptr);
void free_2d_array(void **ptr, size_t n1);
void free_3d_array(void ***ptr, size_t n1, size_t n2);
void free_4d_array(void ****ptr, size_t n1, size_t n2, size_t n3);
void *gmalloc(size_t size);
void *gcalloc(size_t n, size_t size);
void *grealloc(void *ptr, size_t size);

/* Routines in io_utilities.c */
FILE *gfopen(const char *file_name, const char *type);
