#define FFTW
#define GRAPHICS   

/* Include header files for system libraries. */
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/resource.h>

#if defined(COMPAQ)

#include </usr/include/dxmldef.h>

#elif defined(SGI)

#include <fft.h>
#elif defined(FFTW)

#include </usr/local/include/fftw.h> 
/* #include </exec/fftw-2.1.3/RH-6.2/include/dfftw.h> */

#endif

#ifdef GRAPHICS
/* Include the OpenGL and XWindows libraries. */
#include <GL/glx.h>           /* the GL extension for X. */
#include <GL/gl.h>
#include <GL/glu.h>
#include <X11/keysym.h>
#endif

#include "color.h"
#include "nr.h"
#include "nrutil.h"
#include "allocate.h"

#define NDIM                    3
#define TYPE_MAX                6
#define MAX_LINE                200
#define F_MAX			200
#define COUL_COUPLING 		332.0637
#define MAX_TRIALS 		10000000
#define PI                      3.14159265359
#define TWO_PI 			6.28318530718
#define MAX_PAR			20
#define N_ERF_TAB               400000

/* Macro definitions. */
#define SQR(x)             ((x) * (x))
#define CUBE(x)            ((x) * (x) * (x))
#define ABS(x)             ((x) < 0 ? -(x) : (x))
#define MAX(x,y)           ((x) > (y) ? (x) : (y))
#define MIN(x,y)           ((x) < (y) ? (x) : (y))
#define SIGN(a,b)          ((b) >= 0.0 ? fabs(a) : -fabs(a))
#define NINT(x)            ((x) < 0.0 ? (int) ((x) - 0.5) : (int) ((x) + 0.5))
#define FLOOR(x)           ((x) < 0.0 ? ((int) (x)) - 1 : ((int) (x)))
#define degrees_to_radians  PI/180.0

/* These are structures which will be replaced by simple arrays in the
   future! */
/* The atom_cell structure contains the atomic cell index, labels of the
   previous and next entries in the cell list, and the index of the
   corresponding real atom (for phantoms). */
typedef struct {
   int cell,              /* Cell index of atom. */
       prev,              /* Label of previous atom in cell. */
       next,              /* Label of next atom in cell. */
       real;              /* Label of corresponding real atom (for phantoms). */
} atom_cell;

typedef struct {
   int n,        /* Number of phantom cells to create for a given real cell. */
       ic[7];    /* Indices of phantom cells to create. There can be up to */
                 /* seven phantom cells for a given real cell. */
   double d_x,   /* x, y, and z offsets for atoms in a given phantom cell. */
          d_y,
          d_z;
} phantom_cell;

/* nl_entry contains structure of neighbor list */
struct neighb_list {
   int atom;                  /* Label of neighboring atom. */
   struct neighb_list *next;  /* Pointer to next entry in neighbor list. */
};
typedef struct neighb_list nl_entry;

/* The bond_prop structure contains properties of a single bond. */
typedef struct {
   int atom_1,          /* Relative labels of atoms that share bond. */
       atom_2,
       n_diheds,        /* Number of dihedral torsions about bond. */
       order;           /* Bond order. */
   double r_equil,      /* Equilibrium bond length. */
          r2_equil,     /* Square of equilibrium bond length. */
          spring;       /* Spring constant for bond-stretching potential. */
} bond_prop;

/* The angle_prop structure contains properties of a single bond angle. */
typedef struct {
   int atom_1,             /* Relative labels of atoms that share bond angle. */
       atom_2,
       atom_3,
       bond_1,             /* Relative labels of bonds that share bond angle. */
       bond_2;
   double theta_equil,     /* Equilibrium bond angle. */
          sin_theta_equil, /* Sine and cosine of equilibrium bond angle. */
          cos_theta_equil,
          spring_bend;          /* Spring constant for bond angle bending */
                           /* potential. This the spring constant for */
                           /* either the harmonic or cosine harmonic forms */
                           /* of the bond angle bending potential, depending */
                           /* on the value of params.bend_switch. */
}angle_prop;

/* Define a structure to deal with the different kind of variable types
   used by the FFT on different platforms. */
#if defined(COMPAQ)

typedef struct {
   double *Q_linear_re,             /* Arrays of charge interpolation. */
          *Q_linear_im;
   DXML_Z_FFT_STRUCTURE_3D coeff;   /* Internal structure used by the FFT. */
}fft;

#elif defined(SGI)

typedef struct {
   zomplex *Q_linear,  /* Array of charge interpolation. */
           *coeff;     /* Internal array used by the FFT. */
}fft;

#elif defined(FFTW)
typedef struct {
   fftw_complex *Q_linear;             /* Arrays of charge interpolation. */
   fftwnd_plan pfw, pbw;
}fft;
 
#endif



/* Definition of global variables. Variables used by OpenGL. I just was
   lazy.*/
#ifdef MAIN
GLfloat         xAngle = 90.0, yAngle = 0.0, zAngle = .0,
                xTrans = 0.95, yTrans = 0.0, zTrans = -24,
                xAngle_init, yAngle_init, zAngle_init, xPlane = 100;
#else
extern GLfloat         xAngle, yAngle, zAngle, xTrans, yTrans, zTrans,
                       xAngle_init, yAngle_init, zAngle_init, xPlane;
#endif

