#include "build.h"
#include "ff.h"

void compute_pot(int id_0, int id_1, int pot_form, double r2_off, double r2_on, 
     double r2_sep, double ***comb_par, double gamma,
     double three_gamma_over_two, double two_over_gamma_cubed,
     double *u_vdw, double *f_vdw, int *compute_flag) 
{
   double rho_2, rho_6, rho_12, one_over_r2_sep, four_epsilon,
      sw1, sw2, sw3, sw4;
   double ALPHA_COS, BETA_COS, cos_eps, r_min2;

   /* Compute non-bonded interactions. */
   switch (pot_form) {

     /*******************************************************************/
     /*******************    0 = LJ potential    ************************/
     /*******************************************************************/
     case 0 :
            if (r2_sep < r2_off) {

              *compute_flag = 1;

              /* Calculate pair interaction. The LJ pair potential
                 is switched off smoothly between r_on and r_off. */
              one_over_r2_sep = 1.0 / r2_sep;
              rho_2 = comb_par[id_0][id_1][2] * one_over_r2_sep;
              rho_6 = CUBE(rho_2);
              rho_12 = SQR(rho_6);
              *u_vdw = rho_12 - rho_6;
       /*     *u_vdw = rho_12 - 0.001716378;   */
              *f_vdw = rho_12 + *u_vdw;
              four_epsilon = comb_par[id_0][id_1][3];
              (*u_vdw) *= four_epsilon;
              (*f_vdw) *= 6.0 * one_over_r2_sep * four_epsilon;
              if (r2_sep > r2_on) {
                  sw1 = r2_off - r2_sep;
                  sw2 = two_over_gamma_cubed * sw1;
                  sw3 = sw1 * sw2 * (three_gamma_over_two - sw1);
                  sw4 = 6.0 * sw2 * (gamma - sw1);
                  *f_vdw = sw4 * (*u_vdw) + sw3 * (*f_vdw);
                  (*u_vdw) *= sw3;
                  }
            }

       break;

     /*******************************************************************/
     /*******************    1 = WCA potential    ***********************/
     /*******************************************************************/
     case 1 :
            if (r2_sep < comb_par[id_0][id_1][4]) {

              *compute_flag = 1;

              /* Calculate pair interaction. The LJ pair potential
                 is switched off smoothly between r_on and r_off. */
              one_over_r2_sep = 1.0 / r2_sep;
              rho_2 = comb_par[id_0][id_1][2] * one_over_r2_sep;
              rho_6 = CUBE(rho_2);
              rho_12 = SQR(rho_6);
              *u_vdw = rho_12 - rho_6;
       /*     *u_vdw = rho_12 - 0.001716378;   */
              *f_vdw = rho_12 + *u_vdw;
              four_epsilon = comb_par[id_0][id_1][3];
              (*u_vdw) *= four_epsilon;
              (*u_vdw) += comb_par[id_0][id_1][1];
              (*f_vdw) *= 6.0 * one_over_r2_sep * four_epsilon;
            }

       break;

     /*******************************************************************/
     /*******************    2 = LJ + cosine potential    ************************/
     /*******************************************************************/
     case 2 :
            if (r2_sep < r2_off) {

              *compute_flag = 1;

              /* Calculate pair interaction. The LJ pair potential
                 is switched off smoothly between r_on and r_off. */
              one_over_r2_sep = 1.0 / r2_sep;
              rho_2 = comb_par[id_0][id_1][2] * one_over_r2_sep;
              rho_6 = CUBE(rho_2);
              rho_12 = SQR(rho_6);
              *u_vdw = rho_12 - rho_6;
       /*     *u_vdw = rho_12 - 0.001716378;   */
              *f_vdw = rho_12 + *u_vdw;
              four_epsilon = comb_par[id_0][id_1][3];
              ALPHA_COS = comb_par[id_0][id_1][4];
              BETA_COS = comb_par[id_0][id_1][5];
              cos_eps = comb_par[id_0][id_1][6];
              r_min2 = comb_par[id_0][id_1][7];

              if (r2_sep < r_min2) {
              *u_vdw = four_epsilon *( *u_vdw + 0.25);
              (*f_vdw) *= 6.0 * one_over_r2_sep * four_epsilon;
              }else{
                  *u_vdw = cos_eps*(.5*cos(ALPHA_COS*r2_sep+BETA_COS)-0.5);
                  *f_vdw = cos_eps*ALPHA_COS*sin(ALPHA_COS*r2_sep+BETA_COS);
                  }
            }

       break;

     /*******************************************************************/
     /*****************    default = undefined potential    *************/
     /*******************************************************************/
     default :
       printf("pot_form = %d\n", pot_form);
       error_exit("Potential form undefined in compute_pot.\n"); 

       break;
   }
}

/*****************************************************************************/
