#define MAIN
#include "build.h"
#include "ff.h"
#include "proto.h"
#include "stress_prof.h"
#undef MAIN

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  double diff_x, diff_y, diff_z, xx, yy, zz, pe_vdw_s_single,
      pe_vdw_s_p;
  nl_entry *p, *p_term;

  double pe_vdw_s_tot;
  int i_rel, j_rel, j_species;
  int i, j, k, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch, sim_switch, temp_switch;
  /* Random generator */
  long i_ran, seed, idum;
  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;
  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers=1;
  double rho, aspect_xy, aspect_xz; 
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0,
      n_bend = 0, n_stretch = 0;
  mass_entry *mass = NULL;
  stretch_entry *stretch = NULL;
  bend_entry *bend = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;

  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file,
       *bend_file, *stretch_file,
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save, *thermo_file, *trajec_file, string_mem[60];

  FILE *f_thermo, *f_trajec, *f_vels, *f_output;

  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, *n_angles_per_mol, **temp_atm_lab, 
      **temp_atm_nbr, ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;
  int n_free_atom, n_free_mol, level, n_levels, ke_flag=1, eval_flag=1;
  double beta, hot_beta, delta_beta, sqrt_hot_T_over_T, temp_scale,
         temp_time, system_mass_true, system_mass, ps_to_intern,
         intern_to_ps, **comp_forces, delta, at_temp, ke, 
         pe, te, compress;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot, ****comb_chg;
  double ***comb_par, ****prod_chg;
  
  /* Declare arrays used in build */
  double ***corr, **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass, *atom_chg,
      *sqrt_kT_over_m, *one_over_2m, **mol_vels;
  int *atom_rel, *atom_mol, *atom_type, *hot_atom;
  int hot_flag;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;

  /* Variable used in the computation of the potential. */
  double gamma, three_gamma_over_two, two_over_gamma_cubed,
      pe_vdw_s, pe_coul_s, pe_coul_recip, pe_coul_self, pe_vdw_s_check, 
      pe_stretch, pe_bend;
  int bend_switch, vel_switch;

  /* Variable for force and stress tensor calculation */
  double **f_vdw_s, **f_coul_s, **f_coul_recip, **vdw_s_single,  
  **at_stress_vdw_s, **at_stress_coul_s, **at_stress_coul_recip, 
  **at_stress_vdw_single,  **mol_stress_vdw_s,
  **mol_stress_vdw_single, **f_stretch, **at_stress_stretch,
  **mol_stress_stretch, **at_stress, **mol_stress, **at_stress_kin,
  **mol_stress_kin, **mol_stress_vdw, **f_bend, **at_stress_bend,
  **mol_stress_coul_s, **mol_stress_coul_recip;

  /* Thermodynamics parameters. */
  double temp, press, at_press, mol_press, reduce_boltz, volume, boltzmann,
         hot_temp, press_time, r_equil , spring, at_press_vdw_s,
         at_press_coul_s, at_press_coul_recip, at_press_stretch, at_press_bend,
         at_press_kin, mol_press_vdw_s, mol_press_coul_s, mol_press_coul_recip,
         mol_press_kin, spring_bend, cos_theta_equil;

  /* Molecular Dynamics parameters. */
  int i_cycle, n_cycles,
  reshape_axis, n_opt, n_thermo, n_trajec;
  double dr_max, dr_max_old, ratio_dang_dr, ratio_dang_dr_old, 
      ds_mol_max[NDIM], dang_mol_max, 
  dh_max, **old, **s_old, **rel_old, **mol_old, skin = 1.0;

  /* Varibales for constant pressure MD */
  int scale_con;
  double press_scale;
  int  **scale;

  /* Optimization parameters. */
  double opt_time, efficiency, **ds_opt;

  /* Electrostatic parameters. */
  /* Array used for FFT. Because we are using specialized FFT optimized for 
     our platforms, in order to maintain only one function wherever
     our code is running, we create a structure which embed the parameters
     specific to the FFT library we are using. */
#if defined(COMPAQ)
   /* Pointers on arrays elements of the structure must be initialized in 
      order to allow reallocation of memory. */
   fft elec = {NULL, NULL, 0};
   int status, stride_flag;
#elif defined(SGI)
   fft elec = {NULL, NULL};
#elif defined(FFTW)
   fft elec = {NULL, NULL, NULL};
#endif
  double *erfc_sqrt_tab, *erf_sqrt_tab, erf_tab_incr, one_over_erf_tab_incr;
  /* Ewald parameters. */
  int coul_switch, k_cell;
  double accuracy;
  double minus_log_accuracy, alpha, alpha2, *a1, *a2, *a3, *b1, *b2, *b3, 
    g_cutoff, g2_cutoff, two_alpha_over_sqrt_pi;
  int m1_max, m2_max, m3_max;
  double **cos_G_1_dot_r, **sin_G_1_dot_r, **cos_G_2_dot_r, **sin_G_2_dot_r,
         **cos_G_3_dot_r, **sin_G_3_dot_r, 
         *q_cos_G_12_dot_r, *q_sin_G_12_dot_r, *q_cos_G_123_dot_r, 
         *q_sin_G_123_dot_r;
  /* PME parameters. */
  double *b_mod2_x = NULL, *b_mod2_y = NULL, *b_mod2_z = NULL;
  int n_grid_x, n_grid_y, n_grid_z;
  int B_spline_order;
  double delta_grid;
  double **gridded_atom_coords, **M_x, **M_y, **M_z, **dM_du_x, **dM_du_y,
      **dM_du_z;
  double p_norm;

  /* Graphic parameters */
  double radius_sph, radius_cyl;
  int graph_switch, n_graph, resph, antialias_switch, species_choice, 
      keep_going, *comb_col, x_cut_switch;
  char *color_file;

  /* Pore parameters. */
  int pore_switch, graph_pore_switch;
  double x0, y0, z0, r0;
  double pe_pore_s, **f_pore_s, **at_stress_pore, **mol_stress_pore;

  
  /* OpenGL/X variables declaration. */
  Display *dpy;
  Window win;
  GLboolean doubleBuffer = GL_TRUE;
  GLUquadricObj *qobj;

  /* Analysis variables. */
  int nrot, n_reshape;

  /* Block accumulators. */
  int n_block, n_blocks, i_block;  
  /* Variables for stress profile and density profiles */
  int n_slab, ift_switch;
  double *p_normal_vdw, *p_tangent_vdw, *p_normal_coul, *p_tangent_coul,
         **p_normal_vdw_block, **p_tangent_vdw_block, **p_normal_coul_block,
          **p_tangent_coul_block, *p_normal, *p_tangent, **p_tangent_block, **p_normal_block,
           slab_width, slab_vol, *dens_prof, **dens_prof_block, *ift_block,
           *p_tangent_stretch, *p_normal_stretch, *p_tangent_bend, *p_normal_bend;

double **h_block, *vol_block, *rho_block, *at_temp_block, *pe_block, *ke_block,
       *te_block, *pe_vdw_s_block, *pe_coul_s_block, *pe_coul_recip_block, 
       *pe_stretch_block, *pe_bend_block, ***at_stress_block, 
       ***at_stress_vdw_s_block, ***at_stress_coul_s_block,  
       ***at_stress_coul_recip_block, ***at_stress_stretch_block, 
       ***at_stress_bend_block, ***at_stress_kin_block, ***mol_stress_block, 
       ***mol_stress_vdw_s_block, ***mol_stress_coul_s_block, 
       ***mol_stress_kin_block, 
       ***mol_stress_coul_recip_block, *at_press_block, *at_press_vdw_s_block,
       *at_press_coul_s_block, *at_press_coul_recip_block, 
       *at_press_stretch_block, *at_press_bend_block, *at_press_kin_block, 
       *mol_press_block, *mol_press_vdw_s_block, *mol_press_coul_s_block,
       *mol_press_coul_recip_block, *mol_press_kin_block;

  /* Declare cell arrays. */
  atom_cell *atom_cells = NULL;
  phantom_cell *phantoms = NULL;
  int phantom_skip[7], nc[NDIM], nc_p[NDIM], nc_p_total, *first = NULL, 
  *last = NULL, *offsets, *offsets_total, noffsets;
  int *offsets_x, *offsets_y, *offsets_z;

  /* Neighbor list. */ 
  nl_entry **nl_head, **nl_tail; 
  double **atom_move;
  angle_prop **angle_props;
  bond_prop **bond_props;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);


  /* Read in input parameter file. */
  read_simu_params(par_file, &header_file, &config_file, &vel_switch, 
      &header_file_save, &config_file_save, &thermo_file, &trajec_file, 
      &mass_file, &pot_file, &stretch_file, &bend_file, &vdw_rad_switch, &bend_switch, 
      &n_species_chk, &excl_switch, &r_on, &r_off, 
      &neigh_switch, &phant_switch, &kc, &r_nl, &n_cycles, &n_reshape, 
      &reshape_axis, &opt_switch, &dr_max, &ratio_dang_dr, &dh_max, 
      &temp_switch, &temp_time, 
      &press_switch, &scale_con, &press_time, &scale, &temp, &press, 
      &coul_switch, &accuracy, &delta_grid, &B_spline_order,
      &n_graph, &n_opt, &n_thermo, &n_block, 
      &n_trajec, &seed, &delta, 
      &pore_switch, &r0, &z0, 
      &graph_pore_switch, &graph_switch, &color_file, &species_choice, 
      &radius_sph, &radius_cyl, &resph, &antialias_switch, &x_cut_switch,
      &ift_switch, &n_slab);

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("vel_switch = %d\n", vel_switch);
  printf("header_file_save = %s, config_file_save = %s\n",
      header_file_save,config_file_save);
  printf("thermo_file = %s, trajec_file = %s\n",
      thermo_file,trajec_file);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("stretch_file = %s\n",stretch_file);
  printf("bend_file = %s\n",bend_file);
  printf("vdw_rad_switch = %d , bend_switch =%d\n", vdw_rad_switch, bend_switch);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("r_on = %g, r_off = %g\n",r_on, r_off);
  printf("neigh_switch = %d, phant_switch = %d\n", neigh_switch,
      phant_switch);
  printf("kc = %d, r_nl = %g\n",kc, r_nl);
  printf("n_cycles = %d, n_reshape = %d, reshape_axis = %d\n",
      n_cycles, n_reshape, reshape_axis);
  printf("opt_switch = %d\n", opt_switch);
  printf("dr_max = %g, ratio_dang_dr = %g, dh_max = %g\n",
      dr_max, ratio_dang_dr, dh_max);
  printf("temp_switch = %d, temp_time =%g\n", temp_switch, temp_time);
  printf("press_switch = %d, scale_con =%d, press_time =%g\n", press_switch,
          scale_con, press_time);
  for ( i = 0; i < 3; ++i)
     for (j = i; j < 3; ++j)
     printf("scale[%d][%d] = %d\n", i, j, scale[i][j]);

  printf("temp = %g, press = %g\n",temp, press);
  printf("coul_switch = %d, accuracy = %g, delta_grid = %g, B_spline_order = %d\n", coul_switch, accuracy, delta_grid, B_spline_order);
  printf("seed = %ld\n",seed);
  printf("n_graph = %d, n_opt = %d, n_thermo = %d, n_block = %d, n_trajec = %d\n", n_graph, n_opt, n_thermo, n_block, n_trajec);
  printf("delta = %lf\n",delta);
 printf("pore_switch = %d, r0 = %g, z0 = %g\n",pore_switch, r0, z0);
 printf("graph_pore_switch = %d\n", graph_pore_switch);
 printf("graph_switch = %d\n", graph_switch);
 printf("color_file = %s\n", color_file);
 printf("species_choice = %d\n", species_choice);
 printf("radius_sph = %g, radius_cyl = %g\n", radius_sph, radius_cyl);
 printf("resph = %d, antialias_switch = %d\n", resph, antialias_switch);
 printf("x_cut_switch = %d\n", x_cut_switch);
 printf("ift_switch = %d, n_slab= %d\n", ift_switch, n_slab);

  /* Check parameters. */
  if (scale_con < 0 || scale_con > 5){
     printf("scale_con must be between 0 and 5\n");
     exit(1);
  }
     
  if (scale_con != 5 && pore_switch == 1){
     printf("scale_con must be equal to 5 for a pore\n");
     exit(1);
  }

  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;
  noffsets = 1 + kc + kc * (2 * kc + 1) + kc * SQR(2 * kc + 1);

  boltzmann = 1.0;

  /* Compute radial components of the pore (cylindrical pore only!). */
  if (pore_switch)
     x0 = y0 = r0 / sqrt(2.0);

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Read atomic position and velocities from config file */
  read_config_direct(config_file, period_switch, &h, n_atoms, &atom_coords,  
     &atom_vels);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF files. */
  read_mass_params(mass_file, &mass, &n_mass);
  read_stretch_params(stretch_file, &stretch, &n_stretch);
  read_bend_params(bend_file, &bend, &n_bend);

  /* Set up force field data for masses and bending. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, &n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm, &n_angles_per_mol, 
      temp_atm_nbr, temp_atm_br, &bond_props, n_stretch, stretch, 
      &angle_props, n_bend, bend);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* if we consider a pore, add one more integer identifier for the
     walls. This entry cannot be process before because it's not an
     atom type (i.e not read from the structure file). */
  if (pore_switch)
    add_type(&atm_type, &n_type);

  /* Read and Set up force field data for potential interactions. */
  read_set_up_pot(pot_file, vdw_switch, vdw_rad_switch, atm_type, n_type, 
     &comb_pot, &comb_par);

  /* Adjust cutoffs (r_off and r_on) according to the potential interaction 
     form present. */
  adjust_cutoff(n_type, comb_pot, comb_par, &r_on, &r_off); 

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

  /*memory("before allocate");*/
  /* Allocate memory for the stress profile */

  init_stress_prof(n_slab, n_blocks, &p_normal_vdw, &p_tangent_vdw,
                   &p_normal_vdw_block, &p_tangent_vdw_block, &p_normal_coul,
                   &p_tangent_coul, &p_normal_coul_block, &p_tangent_coul_block,
                   &p_normal, &p_tangent, &p_normal_block, &p_tangent_block, &dens_prof,
                   &dens_prof_block, &ift_block, &p_tangent_stretch, &p_normal_stretch,
                   &p_tangent_bend, &p_normal_bend);

  /* Allocate memory for arrays used in the builder. */
  allocate_memory_simu(n_atoms, n_mols, n_species, n_blocks,
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, &atom_chg, &sqrt_kT_over_m, &one_over_2m, 
      &corr, &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, &atom_cells, &offsets, &offsets_total, 
      noffsets, &nl_head, &nl_tail, &atom_move,
      n_atoms_per_mol, &exclusions, &old, &s_old, &rel_old, &mol_old,
      &ds_opt, &offsets_x, &offsets_y, &offsets_z, &f_vdw_s, &vdw_s_single,
      &at_stress_vdw_s, &at_stress_vdw_single, &mol_stress_vdw_s,
      &mol_stress_vdw_single, &mol_range, vel_switch, &atom_vels,
      &mol_vels, &f_stretch, &at_stress_stretch,&mol_stress_stretch,
      &comp_forces, &at_stress, &mol_stress, &at_stress_kin,
      &mol_stress_kin, &mol_stress_vdw, &f_bend, &at_stress_bend,
      pore_switch, &f_pore_s, &at_stress_pore, &mol_stress_pore,
      &prod_chg, &comb_chg, &a1, &a2, &a3, &b1, &b2, &b3,
      &cos_G_1_dot_r, &sin_G_1_dot_r, &cos_G_2_dot_r, &sin_G_2_dot_r,
      &cos_G_3_dot_r, &sin_G_3_dot_r,
      &q_cos_G_12_dot_r, &q_sin_G_12_dot_r, &q_cos_G_123_dot_r, 
      &q_sin_G_123_dot_r, &f_coul_s, &at_stress_coul_s, &f_coul_recip, 
      &at_stress_coul_recip, &gridded_atom_coords, B_spline_order, 
      &M_x, &M_y, &M_z, &dM_du_x, &dM_du_y, &dM_du_z, 
      &mol_stress_coul_s, &mol_stress_coul_recip);

  /*memory("after allocate");*/
allocate_block(n_blocks, &h_block, &vol_block, &rho_block,
               &at_temp_block, &pe_block, &ke_block,
               &te_block, &pe_vdw_s_block, &at_stress_block, 
               &at_stress_vdw_s_block, &at_stress_coul_s_block, 
               &at_stress_coul_recip_block, &at_stress_stretch_block, 
               &at_stress_bend_block, &at_stress_kin_block, 
               &mol_stress_block, &mol_stress_vdw_s_block, 
               &mol_stress_coul_s_block, &mol_stress_coul_recip_block,
               &mol_stress_kin_block,
               &pe_coul_s_block, &pe_coul_recip_block,
               &pe_stretch_block, &pe_bend_block, &at_press_block, 
               &at_press_vdw_s_block, &at_press_coul_s_block,
               &at_press_coul_recip_block, &at_press_stretch_block, 
               &at_press_bend_block, &at_press_kin_block, &mol_press_block,
               &mol_press_vdw_s_block, &mol_press_coul_s_block,
               &mol_press_coul_recip_block, &mol_press_kin_block);

  /*memory("after allocate_block");*/
  /* Initialize potentials, forces and stress tensors. */
  pe_vdw_s = pe_coul_s = pe_coul_recip = pe_coul_self = pe_stretch = 
  pe_bend = pe = ke =  te = 0.0;
  for (i = 0; i < n_atoms; ++i)
     for (j = 0; j < NDIM; ++j)
        f_vdw_s[i][j] = f_coul_s[i][j] = f_coul_recip[i][j] = f_stretch[i][j] = f_bend[i][j] = comp_forces[i][j] = 0.0;
  
  for (i = 0; i < 3; ++i)
     for (j = 0; j < 3; ++j)
        at_stress[i][j] = at_stress_vdw_s[i][j] = at_stress_coul_s[i][j] =
        at_stress_coul_recip[i][j] = at_stress_kin[i][j] = mol_stress[i][j] =
        mol_stress_vdw_s[i][j] = mol_stress_coul_s[i][j] = 
        mol_stress_coul_recip[i][j] = mol_stress_kin[i][j] = 0.0;

  /* Set up array of relative atom indices */
  relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, temp_atm_chg, atom_rel, atom_mol, 
      atom_mass, atom_type, atom_chg, sqrt_kT_over_m, one_over_2m, 
      boltzmann, temp);

  /* Compute product of charges used to compute the REAL PART of the 
     Coulombic potential. */
  if (coul_switch > 0)
     product_charge(n_species, n_atoms_per_mol, temp_atm_chg, prod_chg, 
                    comb_chg); 
/*  memory("after product_charge");  */

  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
  /* Compute geometrical molecular lengths. */
  geom_molecules(n_species, n_atoms_per_mol, temp_atm_pos, mol_range, 
    &mol_max_length);

  /* Calculate box aspect ratio. */
  aspect_xy = h[1][1] / h[0][0];
  aspect_xz = h[2][2] / h[0][0];

  /* Calculate quantities that depend on box dimensions and exit
     if system is too small. */
  box_dimensions(h, h_inv, period_switch, r_off, mol_max_length);

  /* Compute volume and atomic number density. */
  volume = h[0][0] * h[1][1] * h[2][2];
  rho = n_atoms / volume;
  slab_width = h[2][2]/n_slab;
  slab_vol = volume/n_slab;

  if (period_switch) {
    scaled_atomic_coords(n_atoms, h_inv, atom_coords,
        scaled_atom_coords);
    periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
        atom_coords);
  }

  /* Compute center of mass of the molecules and relative atom positions 
     within the molecules. */
  center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      corr, atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

/* Define all the constants used in the simulation */

  /* If we are using periodic boundary conditions, and that we are using
   cell (or neighbor) list, set up atom index offsets for updating phantom 
   atoms. */

  r2_nl = r_nl * r_nl;
  r2_on = r_on * r_on;
  r2_off = r_off * r_off;

  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;

    /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;

   /* Calculate the number of atomic and molecular degrees of freedom. */
      n_free_atom = 3 * n_atoms -3;
      n_free_mol = 3 * n_mols -3 ;

   /* Define Boltzmann's constant (in (kcal/mole)/K) and other constants. */
   beta = 1.0 / (boltzmann * temp);
   delta_beta = hot_beta - beta;

   /* Calculate constants used in Berendsen thermostat 
      and manostat routines. */
   /* Calculate constants used in Berendsen thermostat and manostat 
      routines. */
   compress = 1.0;
   temp_scale = delta/ (2.0 * temp_time);
   press_scale = compress*delta/(3.0 * press_time);

   /* Calculate total mass of system. */
   system_mass_true = 0.0;
   system_mass = 0.0;
   for (i_species = 0; i_species < n_species; ++i_species) {
      system_mass_true += n_mols_per_species[i_species]
         * mol_mass_true[i_species];
      system_mass += n_mols_per_species[i_species]
         * mol_mass[i_species];
   }


/* End of constants definition */
   
    if ( phant_switch == 1) {
      /* Set up cell list with phantom cells. */
      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

      /* Compute coordinates of phantom atoms. */
      update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords);
    } else
      if ( phant_switch == 0){
	/* Set up cell list without phantom cells. */
	set_up_cells_nophantom(h, nc, nc_p, &nc_p_total, atom_cells, kc, 
            period_switch, r_nl, r_off, neigh_switch, &first,
	    &last, offsets_x, offsets_y, offsets_z,
	    n_atoms, scaled_atom_coords, atom_coords);
      }
    if (neigh_switch == 2) {
       if (phant_switch == 0)
          error_exit("Neighbor lists work only with phantom cells\n"); 

       neighbor_lists_period(mol_species, atom_rel, atom_mol,  n_atoms,
          n_atoms_per_mol, exclusions, h, r2_on,  r2_off, scaled_atom_coords, 
          period_switch, first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords, atom_move,
          nl_head, nl_tail, r2_nl);
        }
  }

  /* Sample velocities if vel_switch == 1, otherwise use the velocities 
     read in from the configuration file. */
  if (vel_switch)
     sample_velocities(&i_ran, atom_vels, n_atoms, sqrt_kT_over_m);

  /* Compute initial kinetics energy. */
  center_of_mass_velocities(n_mols, mol_vels, atom_vels, atom_mass, mol_mass,
                 mol_first_atm, n_atoms_per_mol, mol_species);

  kinetic_energy_and_temperature(n_mols, n_atoms, mol_species,
         mol_mass, atom_vels, mol_vels, boltzmann, n_free_atom,
                       n_free_mol, atom_mass, &at_temp, &ke);


  /* Electrostatic initialisation. */
  /* Compute convergence parameter for electrostatic and initialize 
     Ewald/PME. */
  if (coul_switch > 0){

    /* Create lookup table arrays. */
    create_lookup_tables(accuracy, &one_over_erf_tab_incr, &erfc_sqrt_tab, 
                         &erf_sqrt_tab);

    /* Compute convergence parameter (use Finchman criterion). */
    minus_log_accuracy = -log(accuracy);
    alpha = sqrt(minus_log_accuracy) / r_off;
    alpha2 = SQR(alpha);
    two_alpha_over_sqrt_pi = 2.0 * alpha / sqrt(PI);

    /* Calculate Ewald self-energy correction. */
    ewald_self(n_atoms, atom_chg, alpha, &pe_coul_self);

    /* If coul_switch == 1, initialize Ewald, if coul_switch == 2,
       initialize Particle Mesh  Ewald (PME). */

    if (coul_switch == 1){  /* Initialize conventional Ewald. */

       /* Compute reciprocal cutoff (use Finchman criterion). */
       g_cutoff = 2.0 * minus_log_accuracy / r_off;
       g2_cutoff = SQR(g_cutoff);

       /* Initialize reciprocal vector numbers. */
       m1_max = m2_max = m3_max = 0;

       init_ewa(h, h_inv, volume, g_cutoff, n_atoms, &m1_max, &m2_max, &m3_max, 
                a1, a2, a3, b1, b2, b3, &cos_G_1_dot_r, &sin_G_1_dot_r, 
                &cos_G_2_dot_r, &sin_G_2_dot_r, &cos_G_3_dot_r, &sin_G_3_dot_r);

       /* Because we will used only charged sites, initialize to zero
          the arrays used in Ewald. That's cleaner! */ 
       init_array_ewald(n_atoms, m1_max, m2_max, m3_max, cos_G_1_dot_r, 
                        sin_G_1_dot_r, cos_G_2_dot_r, sin_G_2_dot_r,
                        cos_G_3_dot_r, sin_G_3_dot_r, q_cos_G_12_dot_r, 
                        q_sin_G_12_dot_r, q_cos_G_123_dot_r, q_sin_G_123_dot_r);
    }
    else if (coul_switch == 2) {  /* Initialize PME. */
       /* Initialize grid points for the interpolation. */
       n_grid_x = n_grid_y = n_grid_z = 0;

#ifdef COMPAQ
       /* Compaq FFT needs to be initialized before being passed. 
          Matt doesn't like it but that's life! */

       stride_flag = TRUE; 
       status = zfft_init_3d_(&n_grid_x, &n_grid_y, &n_grid_z, &(elec.coeff), 
                              &stride_flag);
#endif
       init_pme(h, volume, a1, a2, a3, delta_grid, &n_grid_x, &n_grid_y,    
                &n_grid_z, &b_mod2_x, &b_mod2_y, &b_mod2_z, B_spline_order, b1, 
                b2, b3, &elec);

       /* Because we will used only charged sites, initialize to zero
          the arrays used in PME. That's cleaner! */ 
       init_array_pme(n_atoms, B_spline_order, gridded_atom_coords, 
                      M_x, M_y, M_z, dM_du_x, dM_du_y, dM_du_z);
    }
  }

  /* Compute the potential energy of the initial state. */
  gamma = 0.0;
  three_gamma_over_two = 0.0;
  two_over_gamma_cubed = 0.0;
  if (r2_on < r2_off) {
    gamma = r2_off - r2_on;
    three_gamma_over_two = 1.5 * gamma;
    two_over_gamma_cubed = 2.0 / CUBE(gamma);
    }

#ifdef DEBUG

   /* Store atomic positions and charges to check results. */
   if ((f_output = fopen("charges.asc", "w")) == NULL)
      error_exit("Unable to open configuration file in smu_md");
   fprintf(f_output,"%lf %lf %lf\n", h[0][0], h[1][1], h[2][2]);
   for (i=0;i<n_atoms;++i)
        fprintf(f_output,"%lf %lf %lf %lf\n",atom_coords[i][0], atom_coords[i][1], atom_coords[i][2], atom_chg[i]);
   fclose(f_output);

#endif

   /* Compute non-bonded van der Waals interactions and non-bonded short range
      Coulombic interactions (if coul_switch > 0). This routine uses 
      a cell list search with phantoms cells. */

   wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s, &pe_coul_s, coul_switch,
          alpha, alpha2, one_over_erf_tab_incr, erfc_sqrt_tab,
          two_alpha_over_sqrt_pi, prod_chg, comb_chg, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          f_vdw_s, f_coul_s, at_stress_coul_s, mol_stress_coul_s,
          p_normal_vdw, p_tangent_vdw, p_normal_coul, p_tangent_coul, 
          slab_width, ift_switch, n_slab);


#ifdef DEBUG 
   /* Check non-bonded vdW and real Coulombic with N2 search. */

   printf("with cell : pe_vdw = %g, pe_coul_s = %g\n", pe_vdw_s, pe_coul_s);

   /* Non-bonded vdW. */
   lj_s_period(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
               n_atoms_per_mol, exclusions, comb_pot, comb_par, h, r2_on, 
               r2_off, scaled_atom_coords, scaled_mol_coords, 
               rel_atom_coords, gamma, three_gamma_over_two, 
               two_over_gamma_cubed, &pe_vdw_s, f_vdw_s, mol_stress_vdw_s);

   /* Coulombic real part. */
   erf_tab_incr = 1.0 / one_over_erf_tab_incr;
   ewald_real_all_pairs(n_atoms, scaled_atom_coords, atom_chg,
                        a1, a2, a3, alpha, r2_off, erf_tab_incr, 
                        erfc_sqrt_tab, &pe_coul_s, at_stress_coul_s, f_coul_s);

   printf("with N2 : pe_vdw = %g, pe_coul_s = %g\n", pe_vdw_s, pe_coul_s);

for (i = 0; i < n_atoms; ++i)
   printf("%d %g %g %g %g %g %g\n", i, f_vdw_s[i][0], f_vdw_s[i][1], f_vdw_s[i][2], f_coul_s[i][0], f_coul_s[i][1], f_coul_s[i][2]); 
   exit(1);
#endif 

      /* Add short-range nonbonded forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_vdw_s[i][k] + f_coul_s[i][k];
      }

      /* Calculate reciprocal part of the non bonded electrostatic
         interactions (if coul_switch == 1, uses conventional Ewald,
         if coul_switch == 2, uses PME). */
      if (coul_switch > 0){
         if (coul_switch == 1)
            ewald_recip(n_atoms, volume, scaled_atom_coords, atom_chg, 
                        b1, b2, b3, m1_max, m2_max, m3_max, alpha, g2_cutoff, 
                        cos_G_1_dot_r, sin_G_1_dot_r, cos_G_2_dot_r, 
                        sin_G_2_dot_r, cos_G_3_dot_r, sin_G_3_dot_r, 
                        q_cos_G_12_dot_r, q_sin_G_12_dot_r, q_cos_G_123_dot_r, 
                        q_sin_G_123_dot_r, &pe_coul_recip, 
                        at_stress_coul_recip, f_coul_recip);
         else 
            pme_recip(n_atoms, n_grid_x, n_grid_y, n_grid_z, 
                      scaled_atom_coords, gridded_atom_coords, B_spline_order, 
                      M_x, M_y, M_z, dM_du_x, dM_du_y, dM_du_z, atom_chg, 
                      elec, volume, alpha, b1, b2, b3, b_mod2_x, b_mod2_y, 
                      b_mod2_z, &pe_coul_recip, at_stress_coul_recip, 
                      f_coul_recip);

         /* Subtract contributions to long-range Coulomb interactions from
            nonbonded exclusions, which are implicitly contained in the
            reciprocal-space Ewald sum. */
         subtract_nonbonded_exclusions(n_mols, mol_species, mol_first_atm,
                                       n_atoms_per_mol, exclusions, h, volume,
                                       scaled_atom_coords, prod_chg, comb_chg,
                                       alpha, alpha2, two_alpha_over_sqrt_pi, 
                                       one_over_erf_tab_incr, erf_sqrt_tab, 
                                       pe_coul_self, &pe_coul_recip, 
                                       at_stress_coul_recip, f_coul_recip, p_normal_coul,
                                       p_tangent_coul, ift_switch, n_slab);

         /* Add long-range nonbonded Coulombic forces to force accumulators. */
         for (i = 0; i < n_atoms; ++i) {
            for ( k = 0; k < NDIM; ++k)
               comp_forces[i][k] += f_coul_recip[i][k];
         }
     }


#ifdef DEBUG
      /* Print out energies and forces. */
      printf("pe_coul_self = %g\n", pe_coul_self);
      printf("pe_coul_real = %g\n", pe_coul_s);
      printf("pe_coul_recip = %g\n", pe_coul_recip);

      for (i = 0; i < n_atoms; ++i){
          printf("%d %g %g %g\n", i, f_coul_s[i][0], f_coul_s[i][1], f_coul_s[i][2]);
          printf("%d %g %g %g\n", i, f_coul_recip[i][0], f_coul_recip[i][1], f_coul_recip[i][2]);
      }
      exit(1); 

#endif

   /* Calculate bond stretching interactions and add contributions to force
      accumulators. */

       /* Calculate bond stretching interactions. */
       stretch_harmonic(period_switch, eval_flag, 
             f_stretch, mol_first_atm, n_bonds_per_mol,at_stress_stretch,
             &pe_stretch, n_atoms, n_mols, mol_species,
             temp_bonds_1, temp_bonds_2, h, scaled_atom_coords, bond_props,
             ift_switch, n_slab, p_tangent_stretch, p_normal_stretch);

      /* Add bond stretching forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_stretch[i][k];
       }
    
   /* Calculate bond angle bending interactions and add contributions to force
      accumulators. */
   if (bend_switch) {
      bend_cos_harmonic(period_switch, eval_flag, f_bend, mol_first_atm, 
                        n_angles_per_mol, at_stress_bend, &pe_bend,
                        n_atoms, n_mols, mol_species, angle_props, h, 
                        scaled_atom_coords, ift_switch, n_slab, 
                        p_tangent_bend, p_normal_bend);
    
      /* Add bond angle bending  forces to force accumulators. */
         for (i = 0; i < n_atoms; ++i) {
            for (k = 0; k < NDIM; ++k)
               comp_forces[i][k] += f_bend[i][k];
      }
   }

   /* Calculate interactions with the pore walls. */
   if (pore_switch) {
      force_pore(n_atoms, n_type, atom_type, comb_pot, comb_par, r2_on,
                 r2_off, gamma, three_gamma_over_two, two_over_gamma_cubed, 
                 &pe_pore_s, atom_coords, r0, x0, y0, z0, at_stress_pore, 
                 mol_stress_pore, f_pore_s);

    /* Add pore forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_pore_s[i][k];
      }
   }

 /* Compute initial total potential and total energies. */
 pe = pe_vdw_s + pe_coul_s + pe_coul_recip + pe_stretch + pe_bend;
 te = pe + ke;

   /* Evaluate the initail stress tensors. Note that we didn't include 
      the atomic stress contribution from the pore!. Fix it later! */

   stress_tensors(ke_flag, at_stress_kin, mol_stress_kin,
                  atom_mass, atom_vels, mol_vels,
                  n_atoms, n_mols, mol_species, h,
                  mol_stress, at_stress, at_stress_vdw_s,
                  mol_stress_vdw, n_free_atom, n_free_mol,
                  boltzmann, temp, at_stress_stretch,
                  mol_stress_vdw_s, mol_mass, at_stress_bend,
                  at_stress_coul_s, at_stress_coul_recip,
                  mol_stress_coul_s, mol_stress_coul_recip);

  /* Open output files. */
  if ((f_thermo = fopen(thermo_file, "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");
  if ((f_trajec = fopen(trajec_file, "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");
  if ((f_vels = fopen("sim.vels", "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");

  /* Compute beta = 1 / kT (we are using k = 1). */
  reduce_boltz = 1.0 / temp;

  /* Write header of the trajectory file. */
  fwrite(&n_atoms, sizeof(int), 1, f_trajec);
  fwrite(&n_cycles, sizeof(int), 1, f_trajec);
  fwrite(&n_trajec, sizeof(int), 1, f_trajec);

  /* Initialize MD loop counter. */
  i_cycle = 0;

  /* Compute atomic and molecular contribution to hydrostatic pressure. */
  compute_hydrostatic(at_stress_vdw_s, at_stress_coul_s, at_stress_coul_recip,
                     at_stress_stretch, at_stress_bend, at_stress, 
                     at_stress_kin, mol_stress_vdw_s, mol_stress_coul_s,
                     mol_stress_coul_recip, mol_stress, mol_stress_kin, 
                     &at_press_vdw_s, &at_press_coul_s, &at_press_coul_recip,
                     &at_press_stretch, &at_press_bend, &at_press, 
                     &at_press_kin, &mol_press_vdw_s, &mol_press_coul_s,
                     &mol_press_coul_recip, &mol_press, &mol_press_kin);

  /* Write thermodynamics quantities to output file. */
  write_thermo(f_thermo, i_cycle, n_atoms, h, volume, rho, at_temp, pe_stretch,
             pe_bend, pe_vdw_s, pe_coul_s, pe_coul_recip, pe, ke, te,
             at_stress_vdw_s, at_stress_coul_s, at_stress_coul_recip,
             at_stress_stretch, at_stress_bend, at_stress, at_stress_kin,
             mol_stress_vdw_s, mol_stress_coul_s, mol_stress_coul_recip, 
             mol_stress, mol_stress_kin, at_press_vdw_s, at_press_coul_s, 
             at_press_coul_recip, at_press_stretch, at_press_bend,
             at_press, at_press_kin, mol_press_vdw_s, mol_press_coul_s,
             mol_press_coul_recip, mol_press, mol_press_kin);

 /* Initialize graphics. */
#ifdef GRAPHICS
if (graph_switch > 0) {
  /* Read and set up color id for each atom type. */
  read_set_up_color(color_file, atm_type, n_type, &comb_col);

  /* Initialize GLX. */
  initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch, antialias_switch,
             h);

  /* Plot initial configuration. Hit Escape to exit the infinite loop.*/
  printf("\nEsc to start the MD simulation.\n");
  XBell(dpy, 100);
  keep_going = 0;
  do {
      redraw(dpy, win, doubleBuffer, qobj, &graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             n_species, &species_choice, atom_type, comb_col, resph, radius_sph,
             &radius_cyl, &keep_going, x_cut_switch, pore_switch);
      if (pore_switch)
        redraw_pore(dpy, win, doubleBuffer, &graph_pore_switch, resph, z0, r0,
                    h, x_cut_switch, comb_col, n_type);

     } while(!keep_going);
   /* Store initial view angles. Can be reset inside the MD loop by pressing 
      Esc. */
   xAngle_init = xAngle;
   yAngle_init = yAngle;
   zAngle_init = zAngle;
 }
#endif

  /* Molecular Dynamics loop */
  for (i_cycle = 1; i_cycle <= n_cycles; ++i_cycle) {
/*
  if (i_cycle % 500 == 0){
     sprintf(string_mem, "before md_loop, i_cycle = %d", i_cycle); 
     memory(string_mem);
  }
*/
   /* Integrate equations of motion. */  
   md_loop(mol_species, n_mols, atom_rel, atom_mol, n_type,
           atom_type, n_atoms, n_atoms_per_mol, exclusions,
           comb_pot, comb_par, r2_on, r2_off, r_off, h, scaled_atom_coords, 
           gamma, three_gamma_over_two, two_over_gamma_cubed,
           &pe_vdw_s, period_switch, &first, &last,
           &phantoms, noffsets, nc, nc_p, &nc_p_total, kc, phantom_skip,
           atom_cells, offsets, corr, atom_coords, rel_atom_coords, at_stress_vdw_s,
           mol_stress_vdw_s, f_vdw_s, comp_forces, atom_vels, delta, &i_ran, 
           sqrt_kT_over_m, atom_mass, atom_move, h_inv, neigh_switch,
           temp_switch, mol_vels, mol_mass, mol_first_atm, n_free_atom, 
           boltzmann, temp, &at_temp, temp_scale, n_free_mol, ke_flag, 
           &pe_stretch, f_stretch, bond_props, vdw_switch, bend_switch, 
           nl_head, nl_tail, r2_nl, r_nl, n_bonds_per_mol,
           at_stress_stretch, eval_flag, temp_bonds_1, temp_bonds_2, &ke, &pe, 
           &te, mol_stress_kin, at_stress_kin, mol_stress, at_stress, 
           mol_stress_vdw, angle_props, &pe_bend, f_bend, at_stress_bend, 
           n_angles_per_mol, pore_switch, r0, x0, y0, z0, &pe_pore_s, 
           f_pore_s, at_stress_pore, mol_stress_pore, press_switch, scale_con, 
           press, press_scale, scale, phant_switch, mol_coords,
           scaled_mol_coords, scan_atm_1, scan_atm_2, n_species, 

           &pe_coul_s, coul_switch, alpha, alpha2, one_over_erf_tab_incr, 
           erfc_sqrt_tab, two_alpha_over_sqrt_pi, prod_chg, comb_chg,
           f_coul_s, at_stress_coul_s, atom_chg, b1, b2, b3, m1_max, m2_max, 
           m3_max, g2_cutoff, cos_G_1_dot_r, sin_G_1_dot_r, cos_G_2_dot_r, 
           sin_G_2_dot_r, cos_G_3_dot_r, sin_G_3_dot_r, q_cos_G_12_dot_r, 
           q_sin_G_12_dot_r, q_cos_G_123_dot_r, q_sin_G_123_dot_r,
           &pe_coul_recip, f_coul_recip, n_grid_x, n_grid_y, n_grid_z,
           gridded_atom_coords, B_spline_order, M_x, M_y, M_z,
           dM_du_x, dM_du_y, dM_du_z, elec, volume, b1, b2, b3, b_mod2_x, 
           b_mod2_y, b_mod2_z, erf_sqrt_tab, pe_coul_self, 
           at_stress_coul_recip, mol_stress_coul_s, mol_stress_coul_recip, 
           p_normal_vdw, p_tangent_vdw, p_normal_coul, p_tangent_coul,
           slab_width, ift_switch, n_slab, p_tangent_stretch, p_normal_stretch,
           p_tangent_bend, p_normal_bend);

   /* If temp_switch == 1, regulate temperature using the Berendsen 
      thermostat. */
   if (temp_switch == 1) 
       nvt_berendsen(n_atoms, temp, atom_vels,temp_scale, at_temp, n_mols, 
                    mol_species, mol_mass, mol_vels, boltzmann, n_free_atom, 
                    n_free_mol, atom_mass);


   /* If press_switch == 1, regulate pressure using the Berendsen manostat. */
   if (press_switch == 1) {

       manostat(n_mols, n_atoms, mol_species, n_atoms_per_mol, mol_coords, 
                atom_coords, scaled_atom_coords, h, h_inv, at_stress, 
                scale_con, r_off, r2_nl, r_nl, press, neigh_switch, 
                phant_switch, &first, &last, &phantoms, nc, nc_p, &nc_p_total, 
                kc, phantom_skip, atom_cells, offsets, press_scale, 
                period_switch, scale, mol_first_atm, mol_stress);

       /* Re-initialize quantities used in the computation of the electrostatic
          potential which depend of the box dimension. */
       if (coul_switch == 1) {  /* Conventional Ewald. */

          init_ewa(h, h_inv, volume, g_cutoff, n_atoms, &m1_max, &m2_max, 
                   &m3_max, a1, a2, a3, b1, b2, b3, &cos_G_1_dot_r, 
                   &sin_G_1_dot_r, &cos_G_2_dot_r, &sin_G_2_dot_r, 
                   &cos_G_3_dot_r, &sin_G_3_dot_r);

          /* Because we will used only charged sites, initialize to zero
             the arrays used in Ewald. That's cleaner! */

          init_array_ewald(n_atoms, m1_max, m2_max, m3_max, cos_G_1_dot_r,
                           sin_G_1_dot_r, cos_G_2_dot_r, sin_G_2_dot_r,
                           cos_G_3_dot_r, sin_G_3_dot_r, q_cos_G_12_dot_r,
                           q_sin_G_12_dot_r, q_cos_G_123_dot_r, q_sin_G_123_dot_r);
        }
        else if (coul_switch == 2) {

            init_pme(h, volume, a1, a2, a3, delta_grid, &n_grid_x, &n_grid_y,
                &n_grid_z, &b_mod2_x, &b_mod2_y, &b_mod2_z, B_spline_order, b1,
                b2, b3, &elec);

             /* Because we will used only charged sites, initialize to zero
                the arrays used in PME. That's cleaner! */

            init_array_pme(n_atoms, B_spline_order, gridded_atom_coords,
                           M_x, M_y, M_z, dM_du_x, dM_du_y, dM_du_z);
        }
  }


#ifdef GRAPHICS
    if (graph_switch > 0 && i_cycle % n_graph == 0){
      center_of_mass_positions(period_switch, n_mols, n_species,
          n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
          corr, atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
          mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);
      redraw(dpy, win, doubleBuffer, qobj, &graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             n_species, &species_choice, atom_type, comb_col, resph, radius_sph,
             &radius_cyl, &keep_going, x_cut_switch, pore_switch);
      if (pore_switch)
        redraw_pore(dpy, win, doubleBuffer, &graph_pore_switch, resph, z0, r0,
                    h, x_cut_switch, comb_col, n_type);
    }
#endif

  /* Compute volume and atomic number density. */
  /* In the future, these quantities could be computed inside the manostat. */
    volume = h[0][0] * h[1][1] * h[2][2];
    rho = n_atoms / volume;

  /* Compute atomic and molecular contribution to hydrostatic pressure. */
  compute_hydrostatic(at_stress_vdw_s, at_stress_coul_s, at_stress_coul_recip,
                     at_stress_stretch, at_stress_bend, at_stress, 
                     at_stress_kin, mol_stress_vdw_s, mol_stress_coul_s,
                     mol_stress_coul_recip, mol_stress, mol_stress_kin, 
                     &at_press_vdw_s, &at_press_coul_s, &at_press_coul_recip,
                     &at_press_stretch, &at_press_bend, &at_press, 
                     &at_press_kin, &mol_press_vdw_s, &mol_press_coul_s,
                     &mol_press_coul_recip, &mol_press, &mol_press_kin);

    /* Write instantaneous quantities to thermodynamics file every 
       n_thermo MD cycles. */
    if (i_cycle % n_thermo == 0) {

        printf(" temp %g  ke %g pe %g te %g i_cycle %d\n", at_temp, ke/n_atoms, 
                 pe/n_atoms, te/n_atoms, i_cycle); 
        fflush(NULL);

        write_thermo(f_thermo, i_cycle, n_atoms, h, volume, rho, at_temp, 
             pe_stretch,
             pe_bend, pe_vdw_s, pe_coul_s, pe_coul_recip, pe, ke, te,
             at_stress_vdw_s, at_stress_coul_s, at_stress_coul_recip,
             at_stress_stretch, at_stress_bend, at_stress, at_stress_kin,
             mol_stress_vdw_s, mol_stress_coul_s, mol_stress_coul_recip, 
             mol_stress, mol_stress_kin, at_press_vdw_s, at_press_coul_s, 
             at_press_coul_recip, at_press_stretch, at_press_bend,
             at_press, at_press_kin, mol_press_vdw_s, mol_press_coul_s,
             mol_press_coul_recip, mol_press, mol_press_kin);

   }
   /* compute the total tangential and nomal component of the stress . We have implemented
      the equation given in B. Smit et. al . JPC, 95, 6361, 1991 */

   if (ift_switch > 0){
      /* Calculate density profiles. */
      profiles(n_slab, n_atoms, scaled_atom_coords, h, dens_prof);
      for (i = 0; i < n_slab; ++i){
      p_tangent[i] = (p_tangent_vdw[i] + p_tangent_coul[i] + p_tangent_stretch[i]
                         +p_tangent_bend[i])/2.0;
      p_normal[i] =  (p_normal_vdw[i] + p_normal_coul[i] + p_normal_stretch[i]
                         + p_normal_bend[i]);
     }
   }

    /* Write instantaneous configuration to trajectory file every 
       n_trajec MD cycles. */
    if (i_cycle % n_trajec == 0){
      write_positions_direct(f_trajec, h, n_atoms,
          atom_coords); 

/*      write_vels_direct(f_vels, n_atoms, atom_vels);  */

      /* Save current configuration (header and configuration). */
      write_header_direct(header_file_save, period_switch, n_species,
           n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
           temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
           n_bonds_per_mol, temp_bonds_1,
           temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
           mol_species);

      write_config_direct(config_file_save, period_switch, h,
           n_atoms, atom_coords, atom_vels);
    }
      

    /* Calculate block index. */
    i_block = (i_cycle - 1) / n_block;

    /* Add contributions to block accumulators. */
    accu_block(i_block, h, volume, rho, at_temp, pe, ke, te,
               pe_vdw_s, pe_coul_s, pe_coul_recip, pe_stretch, pe_bend,
               at_stress, at_stress_vdw_s, at_stress_coul_s, 
               at_stress_coul_recip, at_stress_stretch, at_stress_bend,
               at_stress_kin, mol_stress, mol_stress_vdw_s, mol_stress_coul_s, 
               mol_stress_coul_recip, mol_stress_kin, at_press, 
               at_press_vdw_s, at_press_coul_s,
               at_press_coul_recip, at_press_stretch, at_press_bend, 
               at_press_kin, mol_press, mol_press_vdw_s, mol_press_coul_s,
               mol_press_coul_recip, mol_press_kin, h_block, vol_block, 
               rho_block, at_temp_block, pe_block, ke_block, te_block, 
               pe_vdw_s_block, pe_coul_s_block, pe_coul_recip_block, 
               pe_stretch_block, pe_bend_block,
               at_stress_block, at_stress_vdw_s_block,
               at_stress_coul_s_block,at_stress_coul_recip_block,
               at_stress_stretch_block, at_stress_bend_block, 
               at_stress_kin_block, 
               mol_stress_block, mol_stress_vdw_s_block, 
               mol_stress_coul_s_block, mol_stress_coul_recip_block, 
               mol_stress_kin_block,

               at_press_block, at_press_vdw_s_block, at_press_coul_s_block,
               at_press_coul_recip_block, at_press_stretch_block, 
               at_press_bend_block, at_press_kin_block, mol_press_block,
               mol_press_vdw_s_block, mol_press_coul_s_block, 
               mol_press_coul_recip_block, mol_press_kin_block);

     if (ift_switch > 0)
     surface_tension_block(i_block, n_slab, p_normal, p_tangent,
                           dens_prof, p_normal_block, p_tangent_block, dens_prof_block);

    /* Compute and print block averages every n_block MD timesteps. */
    if (i_cycle % n_block == 0) {
        write_block(i_block, n_block, h_block, vol_block, 
               rho_block, at_temp_block, pe_block, ke_block, te_block, 
               pe_vdw_s_block, pe_coul_s_block, pe_coul_recip_block, 
               pe_stretch_block, pe_bend_block,
               at_stress_block, at_stress_vdw_s_block,
               at_stress_coul_s_block,at_stress_coul_recip_block,
               at_stress_stretch_block, at_stress_bend_block, 
               at_stress_kin_block, 
               mol_stress_block, mol_stress_vdw_s_block, 
               mol_stress_coul_s_block, mol_stress_coul_recip_block, 
               mol_stress_kin_block,

               at_press_block, at_press_vdw_s_block, at_press_coul_s_block,
               at_press_coul_recip_block, at_press_stretch_block, 
               at_press_bend_block, at_press_kin_block, mol_press_block,
               mol_press_vdw_s_block, mol_press_coul_s_block, 
               mol_press_coul_recip_block, mol_press_kin_block);
    if (ift_switch > 0)
       write_tension_block(i_block, n_block, n_slab, p_normal_block,
                         p_tangent_block, dens_prof_block,
                         h_block, vol_block, ift_block, i_cycle, temp);
  }

  } /* end of MD loop. */

  /* Close output files. */
  fclose(f_thermo);
  fclose(f_trajec);
  fclose(f_vels);

  /* Save final configuration. */
  write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

  write_config_direct(config_file_save, period_switch, h,
      n_atoms, atom_coords, atom_vels);

  /* Calculate and print to standart output run averages and uncertainties. */
      write_run(n_blocks,
               h_block, vol_block, rho_block, at_temp_block, 
               pe_block, ke_block, te_block, 
               pe_vdw_s_block, pe_coul_s_block, pe_coul_recip_block,
               pe_stretch_block, pe_bend_block, at_stress_block, 
               at_stress_vdw_s_block, at_stress_coul_s_block,
               at_stress_coul_recip_block, at_stress_stretch_block,
               at_stress_bend_block, at_stress_kin_block, mol_stress_block, 
               mol_stress_vdw_s_block, mol_stress_coul_s_block,
               mol_stress_coul_recip_block, mol_stress_kin_block,
               at_press_block, at_press_vdw_s_block, at_press_coul_s_block,
               at_press_coul_recip_block, at_press_stretch_block, 
               at_press_bend_block, at_press_kin_block, mol_press_block,
               mol_press_vdw_s_block, mol_press_coul_s_block,
               mol_press_coul_recip_block, mol_press_kin_block, p_tangent_block, p_normal_block,
               dens_prof_block, ift_block, n_slab, ift_switch);

  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_simu(int n_atoms, int n_mols, int n_species,
int n_blocks, 
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, double **atom_chg,
double **sqrt_kT_over_m, double **one_over_2m, 
double ****corr, double ***mol_coords, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, atom_cell **atom_cells, int **offsets, 
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol, 
int ****exclusions, 
double ***old, double ***s_old, double ***rel_old, double ***mol_old,
double ***ds_opt, int **offsets_x, int **offsets_y, int **offsets_z,
double ***f_vdw_s, double ***vdw_s_single, double ***at_stress_vdw_s,
double ***at_stress_vdw_single, double ***mol_stress_vdw_s,
double ***mol_stress_vdw_single, double ***mol_range, int vel_switch,
double ***atom_vels,
double ***mol_vels, double ***f_stretch, double ***at_stress_stretch, 
double ***mol_stress_stretch, double ***comp_forces,
double ***at_stress, double ***mol_stress, double ***at_stress_kin,
double ***mol_stress_kin, double ***mol_stress_vdw, double ***f_bend,
double ***at_stress_bend, int pore_switch, double ***f_pore_s, 
double ***at_stress_pore, double ***mol_stress_pore, double *****prod_chg,
int *****comb_chg,
double **a1, double **a2, double **a3, double **b1, double **b2, double **b3,
double ***cos_G_1_dot_r, double ***sin_G_1_dot_r, double ***cos_G_2_dot_r,
double ***sin_G_2_dot_r, double ***cos_G_3_dot_r, double ***sin_G_3_dot_r,
double **q_cos_G_12_dot_r, double **q_sin_G_12_dot_r, 
double **q_cos_G_123_dot_r, double **q_sin_G_123_dot_r, 
double ***f_coul_s, double ***at_stress_coul_s,
double ***f_coul_recip, double ***at_stress_coul_recip,
double ***gridded_atom_coords, int B_spline_order, double ***M_x, 
double ***M_y, double ***M_z, double ***dM_du_x, double ***dM_du_y, 
double ***dM_du_z, double ***mol_stress_coul_s, 
double ***mol_stress_coul_recip)
{
  int i, i_rel, i_species, j_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));
  *atom_chg = allocate_1d_array(n_atoms, sizeof(double));
  *sqrt_kT_over_m = allocate_1d_array(n_atoms, sizeof(double));
  *one_over_2m = allocate_1d_array(n_atoms, sizeof(double));

   /* Allocate memory for temporary array. */
   *corr = allocate_1d_array(n_species, sizeof(double**));
   for (i_species = 0; i_species < n_species; ++i_species)
      (*corr)[i_species] = allocate_2d_array(n_atoms_per_mol[i_species], NDIM,
                              sizeof(double));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  *mol_old = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for atomic cell lists. */
  if (period_switch) {
    *atom_cells = allocate_1d_array(8 * n_atoms, sizeof(atom_cell));
    *offsets = allocate_1d_array(noffsets, sizeof(int));
    *offsets_total = allocate_1d_array(noffsets, sizeof(int));
  }
  
  /* Allocate memory for neighbor lists. */
  *nl_head = gcalloc(n_atoms, sizeof(nl_entry*));
  for (i = 0; i < n_atoms; ++i) {
    (*nl_head)[i] = gmalloc(sizeof(nl_entry));
    (*nl_head)[i] -> next = NULL;
    }
  *nl_tail = gcalloc(n_atoms, sizeof(nl_entry*));
  *atom_move = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }

  *prod_chg = allocate_1d_array(n_species, sizeof(double***));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*prod_chg)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(double**));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      (*prod_chg)[i_species][i_rel] = allocate_1d_array(n_species, sizeof(double*));
      for (j_species = 0; j_species < n_species; ++j_species) {
      (*prod_chg)[i_species][i_rel][j_species] = allocate_1d_array(n_atoms_per_mol[j_species], sizeof(double));
    }
  }
  }
  
  *comb_chg = allocate_1d_array(n_species, sizeof(int***));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*comb_chg)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int**));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      (*comb_chg)[i_species][i_rel] = allocate_1d_array(n_species, sizeof(int*));
      for (j_species = 0; j_species < n_species; ++j_species) {
      (*comb_chg)[i_species][i_rel][j_species] = allocate_1d_array(n_atoms_per_mol[j_species], sizeof(int));
    }
  }
  }
  
  /* Direct and Reciprocal basis lattices. */
  /* Direct and Reciprocal basis lattices. */
  *a1 = allocate_1d_array(3, sizeof(double));
  *a2 = allocate_1d_array(3, sizeof(double));
  *a3 = allocate_1d_array(3, sizeof(double));
  *b1 = allocate_1d_array(3, sizeof(double));
  *b2 = allocate_1d_array(3, sizeof(double));
  *b3 = allocate_1d_array(3, sizeof(double));

  n_atoms_max = 0;
  for (i_species = 0; i_species < n_species; ++i_species)
    n_atoms_max = MAX(n_atoms_max, n_atoms_per_mol[i_species]);
  *old = allocate_2d_array(n_atoms_max, 3, sizeof(double));
  *s_old = allocate_2d_array(n_atoms_max, 3, sizeof(double));
  *rel_old = allocate_2d_array(n_atoms_max, 3, sizeof(double));

  /* Allocate memory for optimization array. */
  *ds_opt = allocate_2d_array(n_mols, 3, sizeof(double));


  /* Block accumulators */
/*  *h_block = allocate_2d_array(3, n_blocks, sizeof(double));
  *mol_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_press_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_press_block = allocate_1d_array(n_blocks, sizeof(double));
  *vol_block = allocate_1d_array(n_blocks, sizeof(double));
  *rho_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_vdw_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_stretch_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_bend_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_coul_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_coul_recip_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_mol_moves_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_mol_accept_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_reshape_moves_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_reshape_accept_block = allocate_1d_array(n_blocks, sizeof(double));
*/
  /* Average accumulators. */
/*  *h_ave = allocate_1d_array(3, sizeof(double));
  *h_unc = allocate_1d_array(3, sizeof(double));
  *mol_stress_ave = allocate_2d_array(3, 3, sizeof(double));
  *mol_stress_unc = allocate_2d_array(3, 3, sizeof(double));
  *at_stress_ave = allocate_2d_array(3, 3, sizeof(double));
  *at_stress_unc = allocate_2d_array(3, 3, sizeof(double));
*/

  /* Array of offsets for nophantom case */

  *offsets_x =allocate_1d_array(noffsets, sizeof(int));
  *offsets_y =allocate_1d_array(noffsets, sizeof(int));
  *offsets_z =allocate_1d_array(noffsets, sizeof(int));

  /* Memory for force and stress tensor */

  *f_vdw_s = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *f_coul_s = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *f_coul_recip = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *comp_forces = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *f_stretch = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *f_bend = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *vdw_s_single = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *at_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_coul_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_coul_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_coul_recip = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_coul_recip = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_kin = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_kin = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_stretch = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_stretch = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_bend = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_vdw_single = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_single = allocate_2d_array(NDIM, NDIM, sizeof(double));

  if (pore_switch){
    *f_pore_s = allocate_2d_array(n_atoms, NDIM, sizeof(double));
    *at_stress_pore = allocate_2d_array(NDIM, NDIM, sizeof(double));
    *mol_stress_pore = allocate_2d_array(NDIM, NDIM, sizeof(double));
  }

  /* Memory for geometrical molecular lengths. */
  *mol_range = allocate_2d_array(n_species, NDIM, sizeof(double));
  if (vel_switch)
     *atom_vels = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *mol_vels = allocate_2d_array(n_atoms, NDIM, sizeof(double));

  /* Allocate memory for Ewald arrays. */
  *cos_G_1_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *sin_G_1_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *cos_G_2_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *sin_G_2_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *cos_G_3_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *sin_G_3_dot_r = allocate_1d_array(n_atoms, sizeof(double));

  *q_cos_G_12_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *q_sin_G_12_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *q_cos_G_123_dot_r = allocate_1d_array(n_atoms, sizeof(double));
  *q_sin_G_123_dot_r = allocate_1d_array(n_atoms, sizeof(double));

  /* Allocate memory for PME arrays. */
  *gridded_atom_coords = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *M_x = allocate_2d_array(n_atoms, B_spline_order, sizeof(double));
  *M_y = allocate_2d_array(n_atoms, B_spline_order, sizeof(double));
  *M_z = allocate_2d_array(n_atoms, B_spline_order, sizeof(double));
  *dM_du_x = allocate_2d_array(n_atoms, B_spline_order, sizeof(double));
  *dM_du_y = allocate_2d_array(n_atoms, B_spline_order, sizeof(double));
  *dM_du_z = allocate_2d_array(n_atoms, B_spline_order, sizeof(double));
  
}

/****************************************************************************/

void allocate_block(int n_blocks, double ***h_block, double **vol_block, 
                double **rho_block,
                double **at_temp_block, double **pe_block, double **ke_block,
                double **te_block, double **pe_vdw_s_block, 
                double ****at_stress_block, double ****at_stress_vdw_s_block,
                double ****at_stress_coul_s_block, 
                double ****at_stress_coul_recip_block,
                double ****at_stress_stretch_block, 
                double ****at_stress_bend_block, 
                double ****at_stress_kin_block, 
                double ****mol_stress_block, double ****mol_stress_vdw_s_block,
                double ****mol_stress_coul_s_block,
                double ****mol_stress_coul_recip_block,
                double ****mol_stress_kin_block,
                double **pe_coul_s_block, double **pe_coul_recip_block,
                double **pe_stretch_block, double **pe_bend_block,
                double **at_press_block, double **at_press_vdw_s_block,
                double **at_press_coul_s_block,
                double **at_press_coul_recip_block,
                double **at_press_stretch_block, double **at_press_bend_block,
                double **at_press_kin_block, double **mol_press_block,
                double **mol_press_vdw_s_block, double **mol_press_coul_s_block,
                double **mol_press_coul_recip_block,
                double **mol_press_kin_block)
{

  /* Block accumulators */
  *h_block = allocate_2d_array(3, n_blocks, sizeof(double));
  *vol_block = allocate_1d_array(n_blocks, sizeof(double));
  *rho_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_temp_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_block = allocate_1d_array(n_blocks, sizeof(double));
  *ke_block = allocate_1d_array(n_blocks, sizeof(double));
  *te_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_vdw_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_coul_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_coul_recip_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_stretch_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_bend_block = allocate_1d_array(n_blocks, sizeof(double));

  *at_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_vdw_s_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_coul_s_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_coul_recip_block = 
                            allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_stretch_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_bend_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_kin_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));

  *mol_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *mol_stress_vdw_s_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *mol_stress_coul_s_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *mol_stress_coul_recip_block = 
                             allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *mol_stress_kin_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));

  *at_press_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_press_vdw_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_press_coul_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_press_coul_recip_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_press_stretch_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_press_bend_block = allocate_1d_array(n_blocks, sizeof(double));
  *at_press_kin_block = allocate_1d_array(n_blocks, sizeof(double));

  *mol_press_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_press_vdw_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_press_coul_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_press_coul_recip_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_press_kin_block = allocate_1d_array(n_blocks, sizeof(double));
}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   double **temp_atm_chg, int *atom_rel, int *atom_mol, double *atom_mass, 
   int *atom_type, double *atom_chg, double *sqrt_kT_over_m, 
   double *one_over_2m, double boltzmann, double temp)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
      atom_chg[i] = temp_atm_chg[i_species][i_rel];
      sqrt_kT_over_m[i] = sqrt(boltzmann * temp / atom_mass[i]);
      one_over_2m[i] = 1.0 / (2.0 * atom_mass[i]);
    }
  }

}
