#define MAIN
#include "build.h"
#undef MAIN
#include "ff.h"
#include "proto.h"

main(int argc, char *argv[])
{
int skip, abs;
int i, j, i_atoms, i_species, n_species, n_unit_cells, n_mols, n_atoms;
int period_switch, vdw_rad_switch, init_switch, trial_switch;
/* Random generator */
long i_ran, seed;
/* Declare parameters used to build the initial state and box matrices*/
int n_layers;
double rho, aspect_xy, aspect_xz, layer_spacing;
double **h, **h_inv;
/* Declare and initialize (NULL pointers for Linux!) force field parameters. */
int n_mass = 0, n_lj = 0, n_e6 = 0, n_type = 0;
mass_entry *mass = NULL;
lj_entry *lj = NULL;
e6_entry *e6 = NULL;
pot_entry *pot = NULL;
type_entry *atm_type = NULL;

/* File names */
char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, **struct_file, 
   *header_file, *config_file, *color_file;

/* Declare and initialize molecular structure parameters. */
int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL, 
  *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr, ***temp_atm_br,
  **temp_atm_type_i;
double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg, **temp_atm_sigma, 
   **temp_atm_eps, ***temp_atm_ord;
char ***temp_atm_type;
int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
double **temp_bonds_ord = NULL;
int *n_mols_per_unit_cell, *mol_species;
/* Declare some arrays used in set up force field */
double *mol_mass, *mol_mass_true;
int *mol_first_atm, *mol_first_sphero;
/* Declare combination and exclusion arrays */
double overlap_criterion, **combine;
int **comb_pot;
double ***comb_par;
/* Declare arrays used in build */
double **scaled_atom_coords, **mol_coords, **scaled_mol_coords, **atom_coords,
 **atom_vels;
int *atom_rel, *atom_type = NULL;
/* Array of the chosen principal molecular axe. */
int *principal;
/* Addition for banana mixture */

int polar_switch, graph_switch;
double v0, rho_star, skin, volume, **rel_atom_coords;
double *length, length1, length2, dr_max, ratio_du_dr, dside_max;
int n_sphero, sphero_count, i_mol;

/* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;
  double *atom_mass;

/* OpenGL/X variables declaration. */
    Display *dpy;
    Window win;
    GLboolean doubleBuffer = GL_TRUE;
    GLUquadricObj *qobj;
    double radius_sph, radius_cyl;
    int resph, antialias_switch, species_choice, *comb_col;
    short keep_going;

/* Get command line input. */
if (argc != 2) {
        printf("Usage: %s params_file\n", argv[0]);
        exit(1);
    }
strcpy(par_file, argv[1]);

/* Read in input parameter file. */
read_new_build_params(par_file, &mass_file, &pot_file, &color_file, 
   &period_switch, &n_species, &n_mols_per_unit_cell, &struct_file, 
   &trial_switch, &vdw_rad_switch, &overlap_criterion, &init_switch, 
   &n_layers, &layer_spacing, &rho_star, &n_unit_cells, &aspect_xy, &aspect_xz, 
   &principal, &seed, &length1, &length2, &polar_switch, &skin, 
   &radius_sph, &radius_cyl, &resph, &antialias_switch, &graph_switch, 
   &species_choice, &dr_max, &ratio_du_dr, &dside_max, 
   &header_file, &config_file);

printf("mass_file = %s\n",mass_file);
printf("pot_file = %s\n",pot_file);
printf("color_file = %s\n",color_file);
printf("period_switch = %d\n",period_switch);
printf("n_species = %d\n",n_species);
for (i_species = 0; i_species < n_species; ++i_species)
  printf("n_mol_per_unitcell = %d, struct_file = %s\n",
     n_mols_per_unit_cell[i_species], struct_file[i_species]);
printf("trial_switch = %d\n",trial_switch);
printf("vdw_rad_switch = %d, overlap = %g\n",vdw_rad_switch,overlap_criterion);
printf("init_switch = %d, n_layers = %d, layer_spac = %g\n",init_switch,n_layers,layer_spacing);
printf("rho_star = %g\n",rho_star);
printf("n_unit_cells = %d\n",n_unit_cells);
printf("aspect_xy = %g, aspect_xz = %g\n",aspect_xy, aspect_xz);
for (i_species = 0; i_species < n_species; ++i_species)
  printf("principal = %d\n",principal[i_species]);
printf("seed = %ld\n",seed);
printf("length1 =%g, length2 =%g polar_switch =%d, skin =%g\n", length1, length2, 
            polar_switch, skin);
printf("radius_sph =%g, radius_cyl =%g, antialias_switch=%d\n", radius_sph, radius_cyl,
        antialias_switch);
printf("graph_switch =%d, species_choice =%d\n",graph_switch, species_choice);
printf("dr_max =%g, ratio_du_dr=%g dside_max =%g\n",dr_max, ratio_du_dr, 
         dside_max);
printf("header_file = %s, config_file = %s\n",header_file,config_file);

/* Initialize random number generator. */
   i_ran = - seed;
   ran3(&i_ran);

/* Set up infomations about template atoms and bonds. */
start_new_build(struct_file, &i_ran, trial_switch, n_species, n_unit_cells, 
  n_mols_per_unit_cell, &n_atoms_per_mol, &n_mols_per_species, 
  &n_bonds_per_mol, &temp_atm_lab, &temp_atm_type, &temp_atm_pos, 
  &temp_atm_chg, &temp_atm_nbr, &temp_atm_br, &temp_atm_ord, &temp_bonds_1, 
  &temp_bonds_2, &temp_bonds_ord, &n_mols, &n_atoms, &mol_species);

  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);


  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i,
     &atm_type, &n_type);

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,
     &scan_atm_1, &scan_atm_2);

  /* Read and Set up force field data for potential interactions. 
  read_set_up_pot(pot_file, vdw_rad_switch, atm_type, n_type, &comb_pot, 
    &comb_par); */

/* Precompute overlap criterion for template atomic sites. 
combination_array(overlap_criterion, n_type, comb_pot, comb_par, &combine);
for (i = 0; i < n_type; ++i)
  for (j = 0; j < n_type; ++j)
  printf("type %d %d, com = %g\n", i, j, combine[i][j]);
*/

/* Compute number of sphero Cylinder */
   n_sphero = 0;

   for (i_species = 0; i_species < n_species; ++i_species)
   n_sphero += n_bonds_per_mol[i_species]* n_mols_per_species[i_species];

   printf(" n_sphero %d\n", n_sphero);


/* Allocate memory for arrays used in the builder. */
allocate_memory_build(n_atoms, n_mols, period_switch, &atom_coords, 
   &scaled_atom_coords, &atom_vels, &atom_rel, &atom_type, &mol_coords, 
   &scaled_mol_coords, &h, &h_inv, &rel_atom_coords, &atom_mass, 
   n_sphero, &length, &mol_first_sphero);

/* Set array of relative atom indices */
relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol, temp_atm_type_i, atom_rel, atom_type);

/* Adjust template molecule coordinates */
adjust_template_molecules(n_species, n_atoms_per_mol, principal, 
   temp_atm_mass, temp_atm_pos);

/* Read and set up color id for each atom type. */
  read_set_up_color(color_file, atm_type, n_type, &comb_col);

/* Construct the array for length of the spherocylinder */
 
      sphero_count = 0;
      for (i_mol = 0; i_mol < n_mols; ++i_mol) {
       i_species = mol_species[i_mol];
       mol_first_sphero[i_mol] = sphero_count;
       for (i = 0; i < n_bonds_per_mol[i_species]; ++i){
          if (i_species == 0){
            length[sphero_count + i] = length1;
          }else length[sphero_count + i] = length2;
        }
       sphero_count += n_bonds_per_mol[i_species];
       }

      v0 = PI * ( length2 / 4.0 + 1.0 / 6.0);
      rho = rho_star / v0;

printf(" rho %g v0 %g rho_star %g\n", rho, v0, rho_star);


/* Choose initial state to be built and compute box dimensions*/
if (init_switch == 1)
	{
        h[0][0] = pow(n_mols / (aspect_xy * aspect_xz * rho), 1.0 / 3.0);
        h[1][1] = aspect_xy * h[0][0];
        h[2][2] = aspect_xz * h[0][0];
        volume = h[0][0] * h[1][1] * h[2][2];
    /* Initialize graphics. */
#ifdef GRAPHICS
  if (graph_switch > 0)
      initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch,
                 antialias_switch, h);
#endif
         /* Compute inverse box vectors. */
         box_inverse(h, h_inv);
      isotropic_start(dpy, win, doubleBuffer, qobj, graph_switch, 
                       n_mols, skin, h, h_inv,
                       &i_ran, mol_first_atm, n_atoms_per_mol, temp_atm_pos,
                       mol_coords, scaled_mol_coords, atom_coords,
                       scaled_atom_coords, n_bonds_per_mol, temp_bonds_1,
                       temp_bonds_2,
                       n_species, n_mols_per_species, mol_species, atom_rel,
                       atom_type, species_choice, comb_col,
                       resph, radius_sph, radius_cyl, length, mol_first_sphero);

	}

else if (init_switch == 2)
        {
        h[0][0] = pow(n_mols / (aspect_xy * aspect_xz * rho), 1.0 / 3.0);
        h[1][1] = aspect_xy * h[0][0];
        h[2][2] = aspect_xz * h[0][0];
/*         h[0][0] = h[1][1] = h[2][2] = 10.0;  */
        volume = h[0][0] * h[1][1] * h[2][2];
     
     /* Initialize graphics. */
#ifdef GRAPHICS
  if (graph_switch > 0){

      initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch,
                 antialias_switch, h);
 }
#endif
         /* Compute inverse box vectors. */
         box_inverse(h, h_inv);

     nematic_start(dpy, win, doubleBuffer, qobj, graph_switch, polar_switch,
                       n_mols, skin, h, h_inv,
                       &i_ran, mol_first_atm, n_atoms_per_mol, temp_atm_pos,
                       mol_coords, scaled_mol_coords, atom_coords,
                       scaled_atom_coords, n_bonds_per_mol, temp_bonds_1,
                       temp_bonds_2, 
                       n_species, n_mols_per_species, mol_species, atom_rel,
                       atom_type, species_choice, comb_col,
                       resph, radius_sph, radius_cyl, length, mol_first_sphero);

        }
else if (init_switch == 3)
        {
        h[2][2] = n_layers * layer_spacing;
        h[0][0] = sqrt(n_mols / (aspect_xy * rho * h[2][2]));
        h[1][1] = aspect_xy * h[0][0];
        volume = h[0][0] * h[1][1] * h[2][2];


        /* Initialize graphics. */
#ifdef GRAPHICS
    if (graph_switch > 0)
      initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch,
                 antialias_switch, h);
#endif
         /* Compute inverse box vectors. */
         box_inverse(h, h_inv);

         smectic_start(dpy, win, doubleBuffer, qobj, graph_switch, polar_switch,
                       n_mols, n_layers, skin, h,
                       h_inv, &i_ran, mol_first_atm, n_atoms_per_mol,
                       temp_atm_pos, mol_coords, scaled_mol_coords,
                       atom_coords, scaled_atom_coords, n_bonds_per_mol,
                       temp_bonds_1, temp_bonds_2,
                       n_species, n_mols_per_species, mol_species, atom_rel,
                       atom_type, species_choice, comb_col,
                       resph, radius_sph, radius_cyl, length, mol_first_sphero);

	}
h[0][1] = h[0][2] = h[1][2] = 0.0;  /* Orthorombic box */


/* Write information about template molecules and atoms to header file */
write_header_direct(header_file, period_switch, n_species, n_atoms_per_mol, 
  temp_atm_lab, temp_atm_type, temp_atm_nbr, temp_atm_br, temp_atm_ord, 
  temp_atm_pos, temp_atm_chg, n_bonds_per_mol, temp_bonds_1, temp_bonds_2, 
  temp_bonds_ord, n_mols_per_species, n_mols, mol_species);

/* Write box dimension and atomic coordinates and velocities to 
   configuration file */
write_config_direct(config_file, h, n_atoms, length1, length2, dr_max, ratio_du_dr, 
        dside_max, skin, atom_coords);

/* Compute center of mass of the molecules and relative atom positions
  within the molecules. */
  center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

/* Plot initial configuration. */
   /* Hit Escape to exit the loop.*/
#ifdef GRAPHICS
   if (graph_switch > 0) {
      printf("\nEsc to exit from initial condition and start the main MC loop.\n");
      XBell(dpy, 100);
      keep_going = 0;
      do {
         redraw(dpy, win, doubleBuffer, qobj, graph_switch, n_mols,
                 mol_species, mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
                 mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
                 species_choice, atom_type, comb_col,
                 resph, radius_sph, radius_cyl, &keep_going);

       } while(!keep_going);
   /* Store initial view angles. Can be reset inside the MC loop
      by pressing Esc. */
   xAngle_init = xAngle;
   yAngle_init = yAngle;
   zAngle_init = zAngle;
   }
#endif
}  /* end of main */


/* Allocate memory for static arrays */
void allocate_memory_build(int n_atoms, int n_mols, int period_switch, 
     double ***atom_coords, double ***scaled_atom_coords, 
     double ***atom_vels, int **atom_rel, int **atom_type,
     double ***mol_coords, double ***scaled_mol_coords, double ***h,
     double ***h_inv, double ***rel_atom_coords, double **atom_mass,
     int n_sphero, double **length, int **mol_first_sphero)
{
   int i;

   /* Allocate memory for arrays of atomic properties. */
   *atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));  
   *atom_vels = allocate_2d_array(n_atoms, 3, sizeof(double));  

   if (period_switch)
      *scaled_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

   /* Allocate memory for arrays of atomic properties. */
   *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
   *atom_type = allocate_1d_array(n_atoms, sizeof(int));

   /* Allocate memory for arrays of molecular properties. */
   *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
   if (period_switch)
      *scaled_mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));

   /* Allocate memory for the box matrices */
   /* For now, orthorombic box */
   *h = allocate_2d_array(3, 3, sizeof(double));
   *h_inv = allocate_2d_array(3, 3, sizeof(double));
   *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));
   *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
   *length = allocate_1d_array(n_sphero, sizeof(double));
   *mol_first_sphero = allocate_1d_array(n_sphero, sizeof(double));

}

void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm, int *n_atoms_per_mol, int **temp_atm_type_i, int *atom_rel, int *atom_type)
{
   int i_species, skip, i, i_mol, i_rel;

   /* Set up array of atomic properties. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {
      i_species = mol_species[i_mol];
      skip = mol_first_atm[i_mol];
      for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
         i = skip + i_rel;
         atom_rel[i] = i_rel;
         atom_type[i] = temp_atm_type_i[i_species][i_rel];
      }
   }
}
