/* Define colors for beads and bonds (borrowed from VMD). */

#define REGCLRS		17	

#ifdef MAIN
/* globally-accessible strings with names for the regular colors. */
char *defColorNames[REGCLRS] = {
  (char *) "blue",    (char *) "red",    (char *) "gray",
  (char *) "orange",  (char *) "yellow", (char *) "tan",
  (char *) "silver",  (char *) "green",  (char *) "white",
  (char *) "pink",    (char *) "cyan",   (char *) "purple",
  (char *) "lime",    (char *) "mauve",  (char *) "ochre",
  (char *) "iceblue", (char *) "black" };

/* static data for default colors. */ 
float defaultColor[REGCLRS][3] = {
  { 0.00f, 0.00f, 1.00f }, {  1.0f,  0.0f,  0.0f }, /* BLUE, RED      */
  { 0.75f, 0.75f, 0.75f }, {  1.0f,  0.64f,  0.0f }, /* GREY, ORANGE   */
  { 1.0f,   1.0f,  0.0f }, {  0.82f,  0.70f,  0.55f }, /* YELLOW, TAN    */
  { 0.6f,   0.6f,  0.6f }, {  0.0f,  1.0f,  0.0f }, /* SILVER, GREEN  */
  { 1.0f,   1.0f,  1.0f }, {  1.0f,  0.41f,  0.70f }, /* WHITE, PINK    */
  { 0.0f, 1.0f, 1.0f }, { 1.0f,  0.0f, 1.0f }, /* CYAN, PURPLE   */
  { 0.2f,   0.8f,  0.2f }, {  0.9f,  0.4f,  0.7f }, /* LIME, MAUVE    */
  { 1.0f,   0.5f,  0.3f }, {  0.5f, 0.75f, 0.75f }, /* OCHRE, ICEBLUE */
  { 0.0f,   0.0f,  0.0f }                           /* BLACK          */
};
#else
extern char *defColorNames[REGCLRS];
extern float defaultColor[REGCLRS][3];
#endif
