#include "build.h"

#ifndef CALLBACK
#define CALLBACK
#endif

/*****************************************************************************/
void
fatalError(char *message)
{
    fprintf(stderr, "glx: %s\n", message);
    exit(1);
}

/*****************************************************************************/
void CALLBACK errorCallback(GLenum errorCode)
{
   const GLubyte *estring;

   estring = gluErrorString(errorCode);
   fprintf(stderr, "Quadric Error: %s\n", estring);
   exit(0);
}

/*****************************************************************************/

void initialize(Display **dpy, Window *win, GLboolean doubleBuffer, 
                GLUquadricObj **qobj, int graph_switch, int antialias_switch,
                double **h)
{
/* OpenGL and Xlib variables. */
    XVisualInfo    *vi;
    Colormap        cmap;
    XSetWindowAttributes swa;
    GLXContext      cx;
    XEvent          event;
    GLboolean       needRedraw = GL_FALSE, recalcModelView = GL_TRUE;
    int             dummy;
    double cxx, cyy, czz, vx, vy, vz, size, distance, fovy;
    GLfloat ambient[] = { 0.0, 0.0, 0.0, 1.0 };
    GLfloat diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat position[] = { 0.0, 3.0, 2.0, 0.0 };
    GLfloat lmodel_ambient[] = { 0.4, 0.4, 0.4, 1.0 };
    GLfloat local_view[] = { 0.0 };
static int snglBuf[] = {GLX_RGBA, GLX_DEPTH_SIZE, 16, None};
static int dblBuf[] = {GLX_RGBA, GLX_DEPTH_SIZE, 16, GLX_DOUBLEBUFFER, None};

    GLfloat no_mat[] = { 0.0, 0.0, 0.0, 1.0 };
/*    GLfloat mat_ambient[] = { 0.7, 0.7, 0.7, 1.0 };
    GLfloat mat_ambient_color[] = { 0.8, 0.8, 0.2, 1.0 };
    GLfloat mat_diffuse[] = { 0.1, 0.5, 0.8, 1.0 };
*/
    GLfloat mat_ambient[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat mat_ambient_color[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat mat_diffuse[] = { 1.0, 1.0, 1.0, 1.0 };

    GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
    GLfloat no_shininess[] = { 0.0 };
    GLfloat low_shininess[] = { 5.0 };
    GLfloat high_shininess[] = { 100.0 };
    GLfloat mat_emission[] = {0.3, 0.2, 0.2, 0.0};

/****************************************************************************/
/****************************************************************************/
/*                   XWindow/OpendGL initialisation.                        */ 
/****************************************************************************/
/****************************************************************************/

    /*** (1) open a connection to the X server ***/

    *dpy = XOpenDisplay(NULL);
    if (*dpy == NULL) fatalError("could not open display");

    /*** (2) make sure OpenGL's GLX extension supported ***/

    if(!glXQueryExtension(*dpy, &dummy, &dummy)) 
      fatalError("X server has no OpenGL GLX extension");

    /*** (3) find an appropriate visual ***/

    /* find an OpenGL-capable RGB visual with depth buffer */
    vi = glXChooseVisual(*dpy, DefaultScreen(*dpy), dblBuf);
    if (vi == NULL) {
       vi = glXChooseVisual(*dpy, DefaultScreen(*dpy), snglBuf);
       if (vi == NULL) fatalError("no RGB visual with depth buffer");
       doubleBuffer = GL_FALSE;
    }
    if(vi->class != TrueColor) 
      fatalError("TrueColor visual required for this program");

    /*** (4) create an OpenGL rendering context  ***/

    /* create an OpenGL rendering context */
    cx = glXCreateContext(*dpy, vi, /* no sharing of display lists */ None,
			  /* direct rendering if possible */ GL_TRUE);
    if (cx == NULL) fatalError("could not create rendering context");

    /*** (5) create an X window with the selected visual ***/

    /* create an X colormap since probably not using default visual */
    cmap = XCreateColormap(*dpy, RootWindow(*dpy, vi->screen), vi->visual, AllocNone);
    swa.colormap = cmap;
    swa.border_pixel = 0;
    swa.event_mask = ExposureMask | ButtonPressMask | StructureNotifyMask | 
                     ButtonMotionMask | KeyPressMask;

    *win = XCreateWindow(*dpy, RootWindow(*dpy, vi->screen), 0, 0, 600, 600, 0, vi->depth, InputOutput, vi->visual, CWBorderPixel | CWColormap | CWEventMask,
   &swa);
    XSetStandardProperties(*dpy, *win, "visu", "visu", None, NULL, 0, NULL);

    /*** (6) bind the rendering context to the window ***/

    glXMakeCurrent(*dpy, *win, cx);

    /*** (7) request the X window to be displayed on the screen ***/

    XMapWindow(*dpy, *win);

    /*** (8) configure the OpenGL context for rendering ***/

     *qobj = gluNewQuadric();
     gluQuadricCallback(*qobj, GLU_ERROR,
                        (GLvoid (CALLBACK*) ()) errorCallback);
     gluQuadricDrawStyle(*qobj, GLU_FILL); 
     gluQuadricNormals(*qobj, GLU_SMOOTH);

   if (graph_switch == 2) { 
     *qobj = gluNewQuadric();
     gluQuadricCallback(*qobj, GLU_ERROR,
                        (GLvoid (CALLBACK*) ()) errorCallback);
     gluQuadricDrawStyle(*qobj, GLU_LINE); 
     gluQuadricNormals(*qobj, GLU_NONE);
   }

     /* Material properties. */
     glMaterialfv(GL_FRONT, GL_AMBIENT, no_mat);
     glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
 /*    glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular); */
     glMaterialfv(GL_FRONT, GL_SHININESS, low_shininess);
     glMaterialfv(GL_FRONT, GL_EMISSION, no_mat);

     /* Lights. */
     glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
     glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
     glLightfv(GL_LIGHT0, GL_POSITION, position);
     glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
     glLightModelfv(GL_LIGHT_MODEL_LOCAL_VIEWER, local_view);

     glEnable(GL_LIGHTING);
     glEnable(GL_LIGHT0);

     /* Used in order to change one material property (here the color). */
     glColorMaterial(GL_FRONT, GL_DIFFUSE);
     glEnable(GL_COLOR_MATERIAL);

     /* Blending and antialiasing. */
     if (antialias_switch) {
        glEnable(GL_LINE_SMOOTH);
        glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
     }

    zTrans = -1.5 * h[2][2]; 
    glEnable(GL_DEPTH_TEST); /* enable depth buffering */
    glDepthFunc(GL_LESS);    /* pedantic, GL_LESS is the default */
    glClearDepth(1.0);       /* pedantic, 1.0 is the default */
    /* frame buffer clears should be to black */
    glClearColor(0.0, 0.0, 0.0, 0.0);
    /* set up projection transform */
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(60.0, 1.0, 1.5 * h[2][2] / 2.0, 3.0 * 1.5 * h[2][2] / 2.0);  
    /* establish initial viewport */
    glViewport(0, 0, 600, 600); /* pedantic, full window size 
                                   is default viewport */

}
